<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Auth;

class Journal extends Model
{
    use HasFactory;

    protected $guarded = [];

    public function journal_entry(){
        return $this->hasMany('App\Models\JournalEntry','journal_id');
    }

    public function activity(){
        return $this->hasMany('App\Models\Activity','module_id')->where('module',"Journal");
    }
    
    public function account(){
        return $this->belongsTo('App\Models\Account','account_id');
    }

    public function customer(){
        return $this->belongsTo('App\Models\User','customer_id');
    }

    public function entry_by(){
        return $this->belongsTo('App\Models\User','enteredbyid');
    }

    protected static function boot()
    {
        parent::boot();

        Journal::creating(function($model) {
            $user = Auth::user();
            if($user!=null){
                $model->organisation_id = $user->active_organisation;
                $model->enteredbyid = $user->enteredbyid;
            }
        });
    }
}
