<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Auth;

class LedgerTransaction extends Model
{
    use HasFactory;

    protected $guarded = [];

    public function entry_by(){
        return $this->belongsTo('App\Models\User','enteredbyid');
    }

    protected static function boot()
    {
        parent::boot();

        LedgerTransaction::creating(function($model) {
            $user = Auth::user();
            if($user!=null){
                $model->organisation_id = $user->active_organisation;
                $model->enteredbyid = $user->enteredbyid;
            }
        });
    }
}
