<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Auth;

class Machinery extends Model
{
    use HasFactory;

    protected $guarded = [];

    public function workstation(){
        return $this->belongsTo('App\Models\Workstation','workstation_id');
    }

    public function entry_by(){
        return $this->belongsTo('App\Models\User','enteredbyid');
    }

    public function machine_maintenance(){
        return $this->hasMany('App\Models\MachineMaintenance','machine_id');
    }

    public function operations(){
        return $this->hasMany('App\Models\MachineryOperation','machinery_id');
    }

    protected static function boot()
    {
        parent::boot();

        Machinery::creating(function($model) {
            $user = Auth::user();
            if($user!=null){
                $model->enteredbyid = $user->id;
                // $model->organisation_id = $user->a   ctive_organisation;
            }
        });
    }
}
