<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Auth;

class MaterialRequestion extends Model
{
    use HasFactory;

    protected $guarded = [];

    public function entry_by(){
        return $this->belongsTo('App\Models\User','enteredbyid');
    }

    public function order(){
        return $this->belongsTo('App\Models\Order','order_id');
    }

    public function requisition_items(){
        return $this->hasMany('App\Models\MaterialRequestionItem','requestion_id')->where('rolledback',0);
    }

    protected static function boot()
    {
        parent::boot();

        MaterialRequestion::creating(function($model) {
            $user = Auth::user();
            if($user!=null){
                $model->enteredbyid = $user->id;
                // $model->organisation_id = $user->active_organisation;
            }
        });
    }
}
