<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Auth;

class MaterialRequestionApprove extends Model
{
    use HasFactory;

    protected $guarded = [];

    public function entry_by(){
        return $this->belongsTo('App\Models\User','enteredbyid');
    }

    public function requisition_item(){
        return $this->belongsTo('App\Models\MaterialRequestionItem','requestion_item_id')->where('rolledback',0);
    }

    protected static function boot()
    {
        parent::boot();

        MaterialRequestionApprove::creating(function($model) {
            $user = Auth::user();
            if($user!=null){
                $model->enteredbyid = $user->id;
                // $model->organisation_id = $user->active_organisation;
            }
        });
    }
}
