<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Auth;

class MiceServiceInsurance extends Model
{
    use HasFactory;

    protected $guarded = [];

    public function passenger(){
        return $this->belongsTo('App\Models\User','passenger_insurance_id');
    }

    protected static function boot()
    {
        parent::boot();

        MiceServiceInsurance::creating(function($model) {
            $user = Auth::user();
            if($user!=null){
                $model->enteredbyid = $user->id;
                $model->organisation_id = $user->active_organisation;
            }
        });
    }
}
