<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Auth;

class MiceServiceTour extends Model
{
    use HasFactory;

    protected $guarded = [];

    public function tour_package(){
        return $this->belongsTo('App\Models\TourPackage','tour_package_id');
    }

     protected static function boot()
    {
        parent::boot();

        MiceServiceTour::creating(function($model) {
            $user = Auth::user();
            if($user!=null){
                $model->enteredbyid = $user->id;
                $model->organisation_id = $user->active_organisation;
            }
        });
    }
}
