<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Auth;

class MiceSupplierSummary extends Model
{
    use HasFactory;
    protected $guarded = [];

    public function mice(){
        return $this->belongsTo('App\Models\Mice','mice_id');
    }

    protected static function boot()
    {
        parent::boot();

        MiceSupplierSummary::creating(function($model) {
            $user = Auth::user();
            if($user!=null){
                $model->enteredbyid = $user->id;
                // $model->organisation_id = $user->active_organisation;
            }
        });
    }
}
