<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Auth;

class Order extends Model
{
    use HasFactory;

    protected $guarded = [];

    public function items(){
        return $this->hasMany('App\Models\OrderItem','order_id');
    }

    public function activity(){
        return $this->hasMany('App\Models\Activity','module_id')->where('module',"Journal");
    }

    public function entry_by(){
        return $this->belongsTo('App\Models\User','enteredbyid');
    }

    public function customer(){
        return $this->belongsTo('App\Models\User','customer_id');
    }

    protected static function boot()
    {
        parent::boot();

        Order::creating(function($model) {
            $user = Auth::user();
            if($user!=null){
                // $model->organisation_id = $user->active_organisation;
                $model->enteredbyid = $user->id;
            }
        });
    }
}
