<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Auth;
use App\Service\StaticMaster;

class Payment extends Model
{
    use HasFactory;

    protected $guarded = [];

    public function customer(){
        return $this->belongsTo('App\Models\User', 'customer_id');
    }
    
    public function vendor(){
        return $this->belongsTo('App\Models\User', 'vendor_id');
    }

    public function collected_by(){
        return $this->belongsTo('App\Models\User', 'collectedby_id');
    }

    public function entry_by(){
        return $this->belongsTo('App\Models\User', 'enteredby_id');
    }

    public function pay_mode(){
        return $this->belongsTo('App\Models\Account', 'payment_mode');
    }

    public function to_acc(){
        return $this->belongsTo('App\Models\Account', 'to_acc');
    }
    public function from_acc(){
        return $this->belongsTo('App\Models\Account', 'from_acc');
    }

    public function entries(){
        return $this->hasMany('App\Models\AgainstPayment', 'payment_id');
    }

    public function invoice(){
        return $this->belongsTo('App\Models\Invoice', 'transaction_id');
    }
    public function bill(){
        return $this->belongsTo('App\Models\Bill', 'transaction_id');
    }
    public function credit_note(){
        return $this->belongsTo('App\Models\CreditNote', 'transaction_id');
    }
    public function debit_note(){
        return $this->belongsTo('App\Models\DebitNote', 'transaction_id');
    }
    public function expense(){
        return $this->belongsTo('App\Models\Expense', 'transaction_id');
    }

    protected static function boot()
    {
        parent::boot();

        Payment::creating(function($model) {
            $user = Auth::user();
            if($user!=null){
                $model->enteredby_id = $user->id;
                $model->collectedby_id = $user->id;
                $model->organisation_id = $user->active_organisation;
            }
        });
    }
}
