<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Auth;

class Production extends Model
{
    use HasFactory;

    protected $guarded = [];

    public function item(){
        return $this->belongsTo('App\Models\Item', 'item_id');
    }

    public function bom(){
        return $this->belongsTo('App\Models\Bom', 'bom_id');
    }

    public function order(){
        return $this->belongsTo('App\Models\Order', 'order_id');
    }

    public function batch(){
        return $this->belongsTo('App\Models\Batch', 'batch_id');
    }
    
    public function entry_by(){
        return $this->belongsTo('App\Models\User','enteredbyid');
    }

    public function quality_check(){
        return $this->belongsTo('App\Models\QualityCheck','id','production_id');
    }

    protected static function boot()
    {
        parent::boot();

        Production::creating(function($model) {
            $user = Auth::user();
            if($user!=null){
                // $model->organisation_id = $user->active_organisation;
                $model->enteredbyid = $user->id;
            }
        });
    }
}
