<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Auth;

class ProductionFinishedGood extends Model
{
    use HasFactory;

    protected $guarded = [];

    public function entry_by(){
        return $this->belongsTo('App\Models\User','enteredbyid');
    }

    public function warehouse(){
        return $this->belongsTo('App\Models\Warehouse','warehouse_id');
    }

    protected static function boot()
    {
        parent::boot();

        ProductionFinishedGood::creating(function($model) {
            $user = Auth::user();
            if($user!=null){
                $model->enteredbyid = $user->id;
                // $model->organisation_id = $user->active_organisation;
            }
        });
    }
}
