<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Auth;

class ProductionOperation extends Model
{
    use HasFactory;

    protected $guarded = [];

    public function entry_by(){
        return $this->belongsTo('App\Models\User','enteredbyid');
    }


    public function workstation(){
        return $this->belongsTo('App\Models\Workstation', 'workstation_id');
    }

    public function machinery(){
        return $this->belongsTo('App\Models\Machinery', 'machinery_id');
    }

    public function production(){
        return $this->belongsTo('App\Models\Production', 'production_id');
    }

    public function operations(){
        return $this->belongsTo('App\Models\BomOperation', 'operation_id');
    }

    protected static function boot()
    {
        parent::boot();

        ProductionOperation::creating(function($model) {
            $user = Auth::user();
            if($user!=null){
                $model->enteredbyid = $user->id;
                // $model->organisation_id = $user->active_organisation;
            }
        });
    }
}
