<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Auth;

class ProductionQuantity extends Model
{
    use HasFactory;
    
    protected $guarded = [];

    public function entry_by(){
        return $this->belongsTo('App\Models\User','enteredbyid');
    }

    public function item(){
        return $this->belongsTo('App\Models\Item','item_id');
    }

    protected static function boot()
    {
        parent::boot();

        ProductionQuantity::creating(function($model) {
            $user = Auth::user();
            if($user!=null){
                $model->enteredbyid = $user->id;
                // $model->organisation_id = $user->active_organisation;
            }
        });
    }
}
