<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Auth;

class QualityCheck extends Model
{
    use HasFactory;

    protected $guarded = [];

    public function entry_by(){
        return $this->belongsTo('App\Models\User','enteredbyid');
    }

    public function quality_items(){
        return $this->hasMany('App\Models\QualityCheckItem','qc_id');
    }

    public function production(){
        return $this->belongsTo('App\Models\Production','production_id');
    }

    public function batch(){
        return $this->belongsTo('App\Models\Batch','batch_id');
    }

    protected static function boot()
    {
        parent::boot();

        QualityCheck::creating(function($model) {
            $user = Auth::user();
            if($user!=null){
                $model->enteredbyid = $user->id;
                // $model->organisation_id = $user->active_organisation;
            }
        });
    }
}
