<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Auth;

class SaleOrder extends Model
{
    use HasFactory;

    protected $guarded = [];

    public function items(){
        return $this->hasMany('App\Models\SaleOrderItem', 'transaction_id');
    }

    public function customer(){
        return $this->belongsTo('App\Models\User', 'customer_id');
    }

    public function activity(){
        return $this->hasMany('App\Models\Activity','module_id')->where('module',"Sales Order");
    }
    

    protected static function boot()
    {
        parent::boot();

        SaleOrder::creating(function($model) {
            $user = Auth::user();
            if($user!=null){
                $model->enteredbyid = $user->id;
                $model->organisation_id = $user->active_organisation;
            }
        });
    }
}
