<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Auth;

class StockTransaction extends Model
{
    use HasFactory;
    protected $guarded = [];

    public function warehouse(){
        return $this->belongsTo('App\Models\Warehouse','warehouse_id');
    }

    public function zone(){
        return $this->belongsTo('App\Models\WarehouseZone','zone_id');
    }
    public function rack(){
        return $this->belongsTo('App\Models\WarehouseRack','rack_id');
    }

    public function bin(){
        return $this->belongsTo('App\Models\WarehouseBin','bin_id');
    }

    protected static function boot()
    {
        parent::boot();

        StockTransaction::creating(function($model) {
            $user = Auth::user();
            if($user!=null){
                $model->enteredbyid = $user->id;
                $model->organisation_id = $user->active_organisation;
            }
        });
    }
}
