<?php

namespace App\Models\Tms;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Trailer extends Model
{
    use HasFactory;

    protected $guarded = [];

    public function item(){
        return $this->hasOne('App\Models\Item', 'id', 'item_id');
    }

    public function rim(){
        return $this->hasMany('App\Models\Tms\Trailers\TrailerInstallation','trailer_id', 'id')
                    ->where('type', 'rim')
                    ->where('rolled_back', 0);
    }
    public function tyre(){
        return $this->hasMany('App\Models\Tms\Trailers\TrailerInstallation','trailer_id', 'id')
                    ->where('type', 'tyre')
                    ->where('rolled_back', 0);
    }

    public function stepney_tyre(){
        return $this->hasMany('App\Models\Tms\Trailers\TrailerInstallation','trailer_id', 'id')
                    ->where('type', 'stepney_tyre')
                    ->where('rolled_back', 0);
    }

    public function stepney_rim(){
        return $this->hasMany('App\Models\Tms\Trailers\TrailerInstallation','trailer_id', 'id')
                    ->where('type', 'stepney_rim')
                    ->where('rolled_back', 0);
    }
    
    public function trailer_installations(){
        return $this->hasMany('App\Models\Tms\Trailers\TrailerInstallation','trailer_id', 'id')->where('rolled_back', 0);
    }

    public function documents(){
        return $this->hasMany('App\Models\Tms\Trailers\TrailerDocument','trailer_id');
    }

    public function logistic_provider(){
        return $this->belongsTo('App\Models\User', 'logistic_provider_id');
    }

    public function vehicle(){
        return $this->belongsTo('App\Models\Tms\Vehicle', 'vehicle_id');
    }
}
