<?php

namespace App\Models\Tms;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Vehicle extends Model
{
    use HasFactory;
    protected $guarded = [];

    public function battery(){
        return $this->hasMany('App\Models\Tms\Vehicles\VehicleInstallation','vehicle_id', 'id')
                    ->where('type', 'battery')
                    ->where('rolled_back', 0);
    }

    public function rim(){
        return $this->hasMany('App\Models\Tms\Vehicles\VehicleInstallation','vehicle_id', 'id')
                    ->where('type', 'rim')
                    ->where('rolled_back', 0);
    }
    public function tyre(){
        return $this->hasMany('App\Models\Tms\Vehicles\VehicleInstallation','vehicle_id', 'id')
                    ->where('type', 'tyre')
                    ->where('rolled_back', 0);
    }

    public function stepney_tyre(){
        return $this->hasMany('App\Models\Tms\Vehicles\VehicleInstallation','vehicle_id', 'id')
                    ->where('type', 'stepney_tyre')
                    ->where('rolled_back', 0);
    }

    public function stepney_rim(){
        return $this->hasMany('App\Models\Tms\Vehicles\VehicleInstallation','vehicle_id', 'id')
                    ->where('type', 'stepney_rim')
                    ->where('rolled_back', 0);
    }

    public function trailer(){
        return $this->hasMany('App\Models\Tms\Vehicles\VehicleInstallation','vehicle_id', 'id')
                    ->where('type', 'trailer');
    }

    public function vehicle_installations(){
        return $this->hasMany('App\Models\Tms\Vehicles\VehicleInstallation','vehicle_id', 'id')->where('rolled_back', 0);
    }

    public function documents(){
        return $this->hasMany('App\Models\Tms\Vehicles\VehicleDocument','vehicle_id');
    }

    public function logistic_provider(){
        return $this->belongsTo('App\Models\User','logistic_provider_id');
    }

}
