<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Naksha\TourDestination;
use App\Models\Naksha\TourTravel;
use App\Models\Itinerary;
use Auth;

class TourPackage extends Model
{
    use HasFactory;

    protected $guarded = [];

    //Tour Destination 
    public function tourDestinations()
    {
        return $this->hasMany(TourDestination::class, 'tour_package_id');
    }

    //tour Travels
    public function tourTravels()
    {
        return $this->hasMany(TourTravel::class,'tour_package_id');
    }

    //itineraries
    public function itinerary()
    {
        return $this->hasMany(Itinerary::class,'tour_package_id')->where('is_deleted',0);
    }

    protected static function boot()
    {
        parent::boot();

        TourPackage::creating(function($model) {
            $user = Auth::user();
            if($user!=null){
                $model->enteredbyid = $user->id;
                $model->organisation_id = $user->active_organisation;
            }
        });
    }
}
