<?php

namespace App\Models\Trip;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TripBooking extends Model
{
    use HasFactory;
    protected $guarded = [];

    public function customer()
    {
        return $this->belongsTo('App\Models\User', 'customer_id');
    }

    public function logistics_provider()
    {
        return $this->belongsTo('App\Models\User', 'logistics_provider_id');
    }

    public function vehicle()
    {
        return $this->belongsTo('App\Models\Tms\Vehicle', 'vehicle_id');
    }
    
    public function driver()
    {
        return $this->belongsTo('App\Models\User', 'driver_id');
    }

    public function purchase_order()
    {
        return $this->belongsTo('App\Models\PurchaseOrder', 'purchase_order_id');
    }
}
