<?php

namespace App\Models\Trip;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TripContainer extends Model
{
    use HasFactory;
    protected $guarded = [];

    public function container_owner()
    {
        return $this->belongsTo('App\Models\User', 'container_owner_id');
    }

    public function container_types() {
        return $this->belongsTo('App\Models\cms\Masters\ContainerType','container_type');
    }

    public function trip_booking() {
        return $this->belongsTo('App\Models\Trip\TripBooking','trip_booking_id');
    }
}
