<?php

namespace App\Models\Trip;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TripExpense extends Model
{
    use HasFactory;
    protected $guarded = [];

    public function account()
    {
        return $this->belongsTo('App\Models\Account', 'account_id', 'id');
    }
    public function customer()
    {
        return $this->belongsTo('App\Models\User', 'customer_id', 'id');
    }
    public function vendor()
    {
        return $this->belongsTo('App\Models\User', 'vendor_id', 'id');
    }
    public function paid_by()
    {
        return $this->belongsTo('App\Models\Account', 'paid_by_id',);
    }
}
