<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Auth;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     * 
     */
    protected $guarded = [];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];


    public function account(){
        return $this->belongsTo('App\Models\Account','account_id');
    }
    public function organisation(){
        return $this->hasMany('App\Models\Organisation','user_id');
    }

    public function user_organisation(){
        return $this->hasMany('App\Models\UserOrganisation','user_id');
    }

    public function address(){
        return $this->hasMany('App\Models\Address','user_id');
    }

    public function contact_person(){
        return $this->hasMany('App\Models\ContactPerson','user_id');
    }

    public function billing_address(){
        return $this->belongsTo('App\Models\Address','user_id')->where('is_billing',1);
    }

    public function shipping_address(){
        return $this->belongsTo('App\Models\Address','user_id');
    }

    public function active_organisation(){
        return $this->belongsTo('App\Models\Organisation','active_organisation','organisation_id');
    }
 
    public function quotation(){
        return $this->belongsTo('App\Models\Quotation','customer_id');
    }

    public function sale_order(){
        return $this->belongsTo('App\Models\SaleOrder','customer_id');
    }

    public function Bill(){
        return $this->belongsTo('App\Models\Bill','vendor_id');
    }

    public function invoice(){
        return $this->belongsTo('App\Models\Bill','customer_id');
    }
    
    // public function Bill(){
    //     return $this->belongsTo('App\Models\Bill','customer_id');
    // }
    
    public function bank_details(){
        return $this->hasMany('App\Models\BankDetails','user_id');
    }

    public function cust_transactions(){
        return $this->hasMany('App\Models\Transaction','customer_id');
    }

    public function vendor_transactions(){
        return $this->hasMany('App\Models\Transaction','vendor_id');
    }

    public function documents(){
        return $this->hasMany('App\Models\Document','user_id');
    }

    public function vaccination_details(){
        return $this->hasMany('App\Models\VaccinationDetail','user_id');
    }

    public function insurrance_details(){
        return $this->hasMany('App\Models\InsuranceDetail','user_id');
    }

    public function payment_details(){
        return $this->hasMany('App\Models\PaymentDetail','user_id');
    }

    public function employee(){
        return $this->belongsTo('App\Models\Hrms\Employee','id','user_id');
    }
    
    protected static function boot()
    {
        parent::boot();

        User::creating(function($model) {
            $user = Auth::user();
            if($user!=null){
                $model->enteredbyid = $user->id;
                $model->organisation_id = $user->active_organisation;
            }
        });
    }
}
