<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Auth;

class UserOrganisation extends Model
{
    use HasFactory;
    protected $guarded = [];

    public function organisation(){
        return $this->belongsTo('App\Models\Organisation','organisation_id');
    }

    public function roles(){
        return $this->belongsTo('App\Models\OrganisationRolePermission','role');
    }

    protected static function boot()
    {
        parent::boot();

        UserOrganisation::creating(function($model) {
            $user = Auth::user();
            if($user!=null){
                $model->organisation_id = $user->active_organisation;
            }
        });
    }
}
