<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Auth;

class Warehouse extends Model
{
    use HasFactory;
    protected $guarded = [];

    public function country(){
        return $this->belongsTo('App\Models\Country','country_id');
    }

    public function state(){
        return $this->belongsTo('App\Models\State','state_id');
    }

    public function city(){
        return $this->belongsTo('App\Models\City','city_id');
    }

    protected static function boot()
    {
        parent::boot();

        Warehouse::creating(function($model) {
            $user = Auth::user();
            if($user!=null){
                $model->organisation_id = $user->active_organisation;
            }
        });
    }
}
