<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Auth;

class WarehouseRack extends Model
{
    use HasFactory;

    protected $guarded = [];

    public function warehouse(){
        return $this->belongsTo('App\Models\Warehouse','warehouse_id');
    }

    public function zone(){
        return $this->belongsTo('App\Models\WarehouseZone','zone_id');
    }

    protected static function boot()
    {
        parent::boot();

        WarehouseRack::creating(function($model) {
            $user = Auth::user();
            if($user!=null){
                $model->enteredby = $user->id;
            }
        });
    }
}
