<?php

namespace App\Models\Workshop;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Auth;

class JobCard extends Model
{
    use HasFactory;

    protected $guarded = [];

    public function customer(){
        return $this->belongsTo('App\Models\User', 'customer_id');
    }

    public function driver(){
        return $this->belongsTo('App\Models\User', 'driver_id');
    }

    public function vehicle(){
        return $this->belongsTo('App\Models\Tms\Vehicle', 'vehicle_id');
    }

    protected static function boot()
    {
        parent::boot();

        JobCard::creating(function($model) {
            $user = Auth::user();
            if($user!=null){
                $model->enteredbyid = $user->id;
                // $model->organisation_id = $user->active_organisation;
            }
        });
    }
}
