<?php

namespace App\Models\Workshop;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Workshop\WorkshopInspectionChecklist;
use App\Models\Workshop\WorkshopVisualInspection;
use App\Models\Workshop\WorkshopInspectionPart;
use App\Models\Workshop\JobCard;

class WorkshopInspection extends Model
{
    use HasFactory;
    protected $guarded = [];

    public function checklist()
    {
        return $this->hasMany(WorkshopInspectionChecklist::class, 'inspection_id');
    }

    public function visual_inspection()
    {
        return $this->hasMany(WorkshopVisualInspection::class, 'inspection_id');
    }

    public function parts()
    {
        return $this->hasMany(WorkshopInspectionPart::class, 'inspection_id');
    }
    public function job_card()
    {
        return $this->belongsTo(JobCard::class, 'job_card_id');
    }
    public function template()
    {
        return $this->belongsTo(WorkshopInspectionTemplate::class, 'template_id');
    }
}
