<?php

namespace App\Models\Workshop;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Auth;

class WorkshopMaterialRequestion extends Model
{
    use HasFactory;

    protected $guarded = [];

     public function job_card()
    {
        return $this->belongsTo('App\Models\Workshop\JobCard'::class, 'job_card_id');
    }

    public function user(){
        return $this->belongsTo('App\Models\User','user_id');
    }

    public function entryby(){
        return $this->belongsTo('App\Models\User','enteredbyid');
    }

    protected static function boot()
    {
        parent::boot();

        WorkshopMaterialRequestion::creating(function($model) {
            $user = Auth::user();
            if($user!=null){
                $model->enteredbyid = $user->id;
                // $model->organisation_id = $user->active_organisation;
            }
        });
    }
}
