<?php

namespace App\Models\Workshop;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Auth;

class WorkshopTransactionStore extends Model
{
    use HasFactory;

    protected $guarded = [];

    public function entry_by(){
        return $this->belongsTo('App\Models\User','enteredbyid');
    }

    public function item(){
        return $this->belongsTo('App\Models\Item','item_id');
    }

    public function store(){
        return $this->belongsTo('App\Models\Store','store_id');
    }

    protected static function boot()
    {
        parent::boot();

        WorkshopTransactionStore::creating(function($model) {
            $user = Auth::user();
            if($user!=null){
                $model->enteredbyid = $user->id;
                // $model->organisation_id = $user->active_organisation;
            }
        });
    }
}
