<?php



namespace App\Models\cms;



use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Auth;


class Block extends Model

{

    use HasFactory;

    protected $guarded = [];
    
    public function yard()

    {
        return $this->belongsTo(Yard::class, 'yard_id');
    }

    public function container_types()
    {
        return $this->hasMany(ContainerType::class, 'id', 'container_types');
    }

    public function entrybyid(){
        return $this->belongsTo('App\Models\User','entryby');
    }

    protected static function boot()
    {
        parent::boot();

        Block::creating(function($model) {
            $user = Auth::user();
            if($user!=null)
              $model->entryby = $user->id;
            //$model->companyid = 1;
        });
    }

}

