<?php

// app/Models/Address.php
namespace App\Models\cms;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class CmsPurchaseOrder extends Model
{
    
    use HasFactory;

    protected $guarded = [];

    public function items(){
        return $this->hasMany('App\Models\cms\CmsItemDetail','transaction_id')->where('order_type','purchase_order');
    }

    public function port_details(){
        return $this->belongsTo('App\Models\cms\PortDetail','id','transaction_id')->where('order_type','purchase_order');
    }

    public function vendor(){
        return $this->belongsTo('App\Models\User','vendor_id');
    }
}
