<?php

namespace App\Models\cms;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ContainerActivity extends Model
{
    use HasFactory;

    protected $fillable = [
        'status',
        'load_on_truck_id',
        'date',
        'location',
        'container_nos',
        'address_1',
        'address_2',
        'city',
        'province',
        'country',
        'zip_code',
        'notes'
    ];

    public function load_on_truck(){
        return $this->belongsTo('App\Models\cms\LoadOnTruck','load_on_truck_id');
    }
}
