<?php

namespace App\Models\cms;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Auth;

class ContainerDetail extends Model
{
    use HasFactory;
    protected $guarded = [];

    protected $table='container_details';


    public function container_types() {
        return $this->belongsTo('App\Models\cms\Masters\ContainerType','container_type');
    }

    public function orders(){
        return $this->belongsTo('App\Models\cms\Order','order_id','id');
    }
    public function containers_type(){
        return $this->belongsTo('App\Models\cms\Masters\ContainerType','container_type');
    }
    public function container_owner(){
        return $this->belongsTo('App\Models\User','container_owner_id');
    }

    public function logisticProvider()
    {
        return $this->belongsTo('App\Models\User', 'logistic_provider_id');
    }

    public function yard()
    {
        return $this->belongsTo('App\Models\cms\Yard', 'yard_id');
    }

    public function block()
    {
        return $this->belongsTo('App\Models\cms\Block', 'block_id');
    }
    
    public function vehicleMaster()
    {
        return $this->belongsTo('App\Models\Tms\Vehicle', 'vehicle_master_id', 'vehicle_id');
    }

    // public function images(){
    //     return $this->hasMany('App\Models\cms\Image','container_detail_id');
    // }

    protected static function boot()
    {
        parent::boot();

        ContainerDetail::creating(function($model) {
            $user = Auth::user();
            if($user!=null)
              $model->entryby = $user->id;
            //$model->companyid = 1;
        });
    }

}
