<?php

namespace App\Models\cms;

use Illuminate\Database\Eloquent\Model;
use Auth;

class ContainerOwner extends Model
{
    protected $fillable = [
        'owner_id',
        'company_name',
        'email_address',
        'office_contact_no',
        'contact_person',
        'contact_number',
        'registration_type',
        'registration_no',
        'tax_number',
        'noof_containers',
        'status'
    ];

    // Define relationships if any
     public function banks()
    {
        return $this->hasMany(Bank::class, 'user_id','id')->where('user_type','container-owner');
    }

    public function address()
    {
        return $this->hasMany(Address::class, 'user_id','id')->where('user_type','container-owner');
    }

    public function documents()
    {
        return $this->hasMany(Document::class, 'user_id','id')->where('user_type','container-owner');
    }

    public function entrybyid()
    {
        return $this->belongsTo('App\Models\User','entryby');
    }

    protected static function boot()
    {
        parent::boot();

        ContainerOwner::creating(function($model) {
            $user = Auth::user();
            if($user!=null)
              $model->entryby = $user->id;
            //$model->companyid = 1;
        });
    }
    
}
