<?php

namespace App\Models\cms;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Auth;

class ContainerStatus extends Model
{
    use HasFactory;

    protected $fillable = [
        'container_no',
        'date',
        'container_type',
        'internal_dimension',
        'door_opening',
        'cubic_capacity',
        'cargo_weight',
        'container_status',
        'container_condition',
        'status',
        'bill_no',
        'seal_no',
        'container_owner_id',
        'port_id',
        'booking_no',
        'expected_date'
    ];

    public function entrybyid()
    {
        return $this->belongsTo('App\Models\User','entryby');
    }

    public function container_owner()
    {
        return $this->belongsTo('App\Models\cms\ContainerOwner','container_owner_id');
    }

    public function port()
    {
        return $this->belongsTo('App\Models\cms\Masters\Port','port_id');
    }

    protected static function boot()
    {
        parent::boot();

        ContainerStatus::creating(function($model) {
            $user = Auth::user();
            if($user!=null)
              $model->entryby = $user->id;
            //$model->companyid = 1;
        });
    }
}
