<?php

namespace App\Models\cms;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Auth;

class LoadOnTruck extends Model
{
    use HasFactory;

    protected $fillable = [
        'container_nos',
        'logistic_provider_id',
        'vehicle_id',
        'vehicle_type',
        'vehicle_no',
        'vin_no',
        'phone_number',
        'contact_person',
        'date',
        'status',
        'is_close',
        'driver_contact_no',
        'driver_name',
        'driver_license',
        'location',
        'port_id'
    ];

    public function entrybyid()
    {
        return $this->belongsTo('App\Models\User','entryby');
    }

    public function logistic_provider()
    {
        return $this->belongsTo('App\Models\cms\LogisticProvider','logistic_provider_id');
    }

    public function vehicle()
    {
        return $this->belongsTo('App\Models\Tms\Vehicle','vehicle_id');
    }

    public function vehicle_types()
    {
        return $this->belongsTo('App\Models\cms\Masters\VehicleType','vehicle_type');
    }

    public function port()
    {
        return $this->belongsTo('App\Models\cms\Masters\Port','port_id');
    }

    protected static function boot()
    {
        parent::boot();

        LoadOnTruck::creating(function($model) {
            $user = Auth::user();
            if($user!=null)
              $model->entryby = $user->id;
            //$model->companyid = 1;
        });
    }
}
