<?php

namespace App\Models\cms;

use Illuminate\Database\Eloquent\Model;
use Auth;

class LogisticProvider extends Model
{
    protected $fillable = [
        'logistics_id',
        'company_name',
        'email_address',
        'office_contact_no',
        'contact_person',
        'contact_number',
        'registration_type',
        'registration_no',
        'tax_number',
        'service_offered',
    ];

    // Define relationships if any
     public function banks()
    {
        return $this->hasMany(Bank::class, 'user_id')->where('user_type','logistic-providers');
    }

    public function address()
    {
        return $this->hasMany(Address::class, 'user_id')->where('user_type','logistic-providers');
    }

    public function documents()
    {
        return $this->hasMany(Document::class, 'user_id')->where('user_type','logistic-providers');
    }

    public function entrybyid()
    {
        return $this->belongsTo('App\Models\User','entryby');
    }

    protected static function boot()
    {
        parent::boot();

        LogisticProvider::creating(function($model) {
            $user = Auth::user();
            if($user!=null)
              $model->entryby = $user->id;
            //$model->companyid = 1;
        });
    }
    
}
