<?php

namespace App\Models\cms\Masters;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;

class ContainerType extends Model
{
    //protected $table = 'master_container_type';

    protected $fillable = [
        'id',
        'type',
        'type_size',
        'internal_dimension',
        'door_opening',
        'cubic_capacity',
        'cargo_weight',
        'status',
    ];

    protected static function boot()
    {
        parent::boot();

        ContainerType::creating(function ($model) {
            $user = Auth::user();
            if ($user != null)
                $model->entryby = $user->id;
            //$model->companyid = 1;
        });
    }
}
