<?php

namespace App\Models\cms;

use Illuminate\Database\Eloquent\Model;
use Auth;

class Order extends Model
{
    protected $table = 'cms_orders';

    protected $guarded = [];
    // Define relationships if any

    // public function documents(){
    //     return $this->hasMany('App\Models\Document','user_id')->where('user_type','orders');
    // }
    
    public function container_details(){
        return $this->hasMany('App\Models\cms\ContainerDetail','order_id');
    }
    
    public function container_owner(){
        return $this->belongsTo('App\Models\User','container_owner_id');
    }
    
    public function container_types() {
        return $this->belongsTo('App\Models\cms\Masters\ContainerType','container_type');
    }

    // public function pre_arrival(){

    //     return $this->belongsTo('App\Models\PreArrivalDeparture','id','order_id')->where('order_type','pre_arrival');

    // }

    public function arrival(){

        return $this->belongsTo('App\Models\cms\PreArrivalDeparture','arrival_id','id')->where('order_type','arrival');

    }
    // public function pre_departure(){

    //     return $this->belongsTo('App\Models\PlacedDepartureOrder','id','order_id')->where('order_type','pre_departure');

    // }

    public function departures(){

        return $this->belongsTo('App\Models\cms\PlacedDepartureOrder','departure_id','id');

    }

    public function entrybyid()
    {
        return $this->belongsTo('App\Models\User','entryby');
    }

    protected static function boot()
    {
        parent::boot();

        Order::creating(function($model) {
            $user = Auth::user();
            if($user!=null)
              $model->entryby = $user->id;
            //$model->companyid = 1;
        });
    }

}
