<?php

namespace App\Models\cms;

use Illuminate\Database\Eloquent\Model;
use Auth;

class PlacedDepartureOrder extends Model
{

    protected $table='placed_departure_order';
    protected $guarded = [];

    // Define relationships if any

    public function orders(){
        return $this->belongsTo('App\Models\cms\Order','id','departure_id');
    }

    public function items(){
        return $this->hasMany('App\Models\cms\CmsItemDetail','transaction_id')->whereIn('order_type',['pre_departure','departure']);
    }

    public function vendor(){
        return $this->belongsTo('App\Models\User','vendor_id');
    }

    public function driver(){
        return $this->belongsTo('App\Models\User','driver_id');
    }
    public function vehicle(){
        return $this->belongsTo('App\Models\Tms\Vehicle','vehicle_id');
    }
   
    public function block(){
        return $this->belongsTo('App\Models\cms\Block','block_id');
    }

    public function yard(){
        return $this->belongsTo('App\Models\cms\Yard','yard_id');
    }

    public function logistic_provider(){
        return $this->belongsTo('App\Models\User','logistic_provider_id');
    }

    public function entrybyid()
    {
        return $this->belongsTo('App\Models\User','entryby');
    }

    protected static function boot()
    {
        parent::boot();

        PlacedDepartureOrder::creating(function($model) {
            $user = Auth::user();
            if($user!=null){
                $model->entryby = $user->id;
                $model->reporting_id=$user->reporting_id;
            }
            //$model->companyid = 1;
        });
    }
}
