<?php

namespace App\Models\cms;

use Illuminate\Database\Eloquent\Model;
use Auth;

class PreArrivalDeparture extends Model
{

    protected $table='pre_arrival_departure';
    protected $guarded = [];

    // Define relationships if any

    public function container_details(){
        return $this->hasMany('App\Models\cms\ContainerDetail','order_id','order_id');
    }   

    public function orders(){
        return $this->belongsTo('App\Models\cms\Order','id','arrival_id');
    }

    // public function documents(){
    //     return $this->hasMany('App\Models\cms\Document','user_id')->whereIn('user_type',['pre_arrival','arrival']);
    // }

    public function images(){
        return $this->hasMany('App\Models\cms\Image','order_id')->where('order_type','arrival');
    }

    public function block(){
        return $this->belongsTo('App\Models\cms\Block','block_id');
    }

    public function yard(){
        return $this->belongsTo('App\Models\cms\Yard','yard_id');
    }

    public function entrybyid()
    {
        return $this->belongsTo('App\Models\User','entryby');
    }

    public function vendor()
    {   
        return $this->belongsTo('App\Models\User','vendor_id');
    }

    public function vehicle()
    {   
        return $this->belongsTo('App\Models\Tms\Vehicle','vehicle_id');
    }

    public function driver()
    {   
        return $this->belongsTo('App\Models\User','driver_id');
    }

    public function logistic_provider()
    {   
        return $this->belongsTo('App\Models\User','logistic_provider_id');
    }

    public function items(){
        return $this->hasMany('App\Models\cms\CmsItemDetail','transaction_id');
    }

    public function port_details(){
        return $this->belongsTo('App\Models\cms\PortDetail','id','transaction_id');
    }

    public function ship_details(){
        return $this->belongsTo('App\Models\cms\ShipDetail','id','transaction_id');
    }

    public function trip_booking(){
        return $this->belongsTo('App\Models\Trip\TripBooking','trip_booking_id');
    }

    protected static function boot()
    {
        parent::boot();

        PreArrivalDeparture::creating(function($model) {
            $user = Auth::user();
            if($user!=null){
                $model->entryby = $user->id;
                $model->reporting_id=$user->reporting_id;
            }
        });
    }
}
