<?php

namespace App\Models\cms;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

use Illuminate\Support\Facades\Auth;

class Yard extends Model

{

    use HasFactory;

    protected $guarded = [];


    public function blocks()
    {
        return $this->hasMany(Block::class, 'yard_id');

    }

    
    public function country(){
        return $this->belongsTo('App\Models\Country','country_id');
    }

    public function state(){
        return $this->belongsTo('App\Models\State','state_id');
    }

    public function city(){
        return $this->belongsTo('App\Models\City','city_id');
    }

    public function entrybyid(){
        return $this->belongsTo('App\Models\User','entryby');
    }

    protected static function boot()
    {
        parent::boot();

        Yard::creating(function($model) {
            $user = Auth::user();
            if($user!=null)
              $model->entryby = $user->id;
            //$model->companyid = 1;
        });
    }

}

