<?php

namespace App\Service;
use App\Models\Transaction;
use App\Service\StaticMaster;
use App\Models\Account;
use App\Models\Organisation;
use App\Models\AgainstPayment;
use App\Models\Invoice;
use App\Models\Bill;
use App\Service\TransactionService;
use App\Models\User;
use App\Models\TaxTransaction;
use App\Models\BillItem;
use App\Models\InvoiceItem;
use App\Models\SaleItemTax;
use App\Models\PurchaseItemTax;
use Auth;
use Log;

class AccountsTransactionService
{
    public function get_accounts($acc_name){

        $accounts= Account::where('acc_case_name',$acc_name)->first();
        if($accounts!=null){
            return $accounts;
        } else{
           return null; 
        }
    }

    // Sale Accounts Transactions Record -----------------------------------------
    public function sale_accounts_transaction($transaction){

         //Calling Bill Items
        $invoice_items=InvoiceItem::where('transaction_id',$transaction['id'])
            ->where('rolledback',0)
            ->get();

        $account_array = [];

        // Setting default account as inventory_asset and same account will have sum and tax amount
        foreach ($invoice_items as $item) {
            //check if account_id is null then set default sales account
            if(empty($item['sale_acc_id'])) {
                $invt_account=$this->get_accounts('sales');
                $item['sale_acc_id'] = $invt_account['id'];
            }
            $accountId = $item['sale_acc_id'] ?? 0;
            $amount = $item['gross_amount'] ?? 0;

            if (isset($account_array[$accountId])) {
                $account_array[$accountId]['amount'] += $amount;
                $account_array[$accountId]['tax_amount'] += $item['tax_amount']??0;
            } else {
                $account_array[$accountId] = [
                    'account_id' => $accountId,
                    'amount'     => $amount,
                    'tax_amount' => $item['tax_amount']??0
                ];
            }
        }
        
        //transaction object
        $transaction_accounts=new TransactionService;

        // entry for receivables (Debit) and updating customer balance
        if($transaction['customer_id']>0){

            // Update User (Customer) balance 
            $customer=User::where('id',$transaction['customer_id'])->first();
            $customer['balance']=$customer['balance']+$transaction['total'];
            $customer->update();

            if($customer['account_id']>0){
                $transaction_accounts->createTransaction($customer['account_id'],$transaction,$transaction['customer_id'],'sales',StaticMaster::$SALE_TRANSACTION_TYPE,$transaction['total']??0,0);
            }else{
                $receivables=$this->get_accounts('accounts_receivable');
                $transaction_accounts->createTransaction($receivables['id'],$transaction,$transaction['customer_id'],'sales',StaticMaster::$SALE_TRANSACTION_TYPE,$transaction['total']??0,0);
            }
        }

        // entry for Sales (Revenue) (Credit)
        if($transaction['subtotal']>0){
            foreach ($account_array as $key => $value) {
                $transaction_accounts->createTransaction($value['account_id'],$transaction,$transaction['customer_id'],'sales',StaticMaster::$SALE_TRANSACTION_TYPE,0,$value['amount']??0);
            }
        }

        // entry for discount(Income) (Debit) 
        if($transaction['discount']>0){
            $discount_account=$this->get_accounts('discount');
            $transaction_accounts->createTransaction($discount_account['id'],$transaction,$transaction['customer_id'],'sales',StaticMaster::$SALE_TRANSACTION_TYPE,$transaction['discount']??0,0);
        }

        // entry for all the charges apply on Sales
        if(!is_null($transaction['charges']) && !empty($transaction['charges'])){

            // Convert the charges array to a JSON string
            $chargesJson = json_decode($transaction['charges'],true);

            if (!empty($chargesJson) && is_array($chargesJson)) {

                Log::info($chargesJson);

                foreach ($chargesJson as $key => $value) {

                    //if amount is positive it will be displayed on Credit Side
                    if($value['account_id']>0){
                        
                        if($value['amount']>=0){
                            $transaction_accounts->createTransaction($value['account_id'],$transaction,$transaction['customer_id'],'sales',StaticMaster::$SALE_TRANSACTION_TYPE,0,$value['amount']??0);
                        }else{
                            $transaction_accounts->createTransaction($value['account_id'],$transaction,$transaction['customer_id'],'sales',StaticMaster::$SALE_TRANSACTION_TYPE,$value['amount']??0,0);
                        }
                    }
                    
                }
            }
        }

        // Calculate Taxes,
        $user=Auth::user();

        $organisation=Organisation::where('organisation_id',$user['active_organisation'])
            ->first();

        $tax_type=$organisation['tax_type']??0;
        
        Log::info("tax type :".$tax_type);

        // VAT Tax calculation
        if($tax_type==2){

            //Calculating VAT as tax type 2
            Log::info("VAT tax slab deducted");
            if($transaction['total_tax']>0){

                // Creating VAT Account in Tax Transaction
                $obj['transaction_id']=$transaction['id'];  //Invoice id
                $obj['transaction_type']=StaticMaster::$SALE_TRANSACTION_TYPE;
                $obj['customer_id']=$transaction['customer_id']??0;
                $obj['vendor_id']=0;
                $obj['tax_type']=$tax_type;       //2 for VAT
                $obj['net_amount']=$transaction['total_gross_amount'];   //Amount before Tax
                $obj['tax_rate']=$transaction['tax_percent']??0;     //Vat Rate
                $obj['tax_amount']=$transaction['total_tax'];     // Calculated Tax
                $obj['gross_amount']=$transaction['total']; // Net + Tax
                $obj['hsn_code']=null;
                $obj['reference_id']=$transaction['id'];
                $obj['notes']=$transaction['notes'];

                $taxtransaction=TaxTransaction::create($obj);
 
                $vat_account=$this->get_accounts('output_v_a_t');
                $transaction_accounts->createTransaction($vat_account['id'],$transaction,$transaction['customer_id'],'sales',StaticMaster::$SALE_TRANSACTION_TYPE,0,$transaction['total_tax']);
            }
        }

        // GST Tax calculation
        if ($tax_type == 1) {
            Log::info("GST tax slab deducted");

            $grouped = [];

            foreach ($invoice_items as $item) {
                $hsn      = $item['hsn_code'];
                $rate     = $item['tax_rate'];   // GST % like 5, 12, 18
                // $cessRate = $item['cess_rate'] ?? 0; // Optional cess %

                $taxable = $item['quantity'] * $item['rate'];

                Log::info("organisation state id :".$organisation['state_id']);

                // Intra-state => CGST + SGST
                if ($transaction['place_of_supply_id'] == $organisation['state_id']) {

                    Log::info("Intra-state => CGST + SGST");
                    $cgst = $item['tax_amount'] / 2;
                    $sgst = $item['tax_amount'] / 2;
                    $igst = 0;

                } else {

                    Log::info("Inter-state => IGST only");
                    // Inter-state => IGST only
                    $cgst = 0;
                    $sgst = 0;
                    $igst = $item['tax_amount'];
                }

                // CESS calculation
                // $cess = $cessRate > 0 ? $taxable * ($cessRate / 100) : 0;

                // Unique key for grouping (HSN + GST slab + cess slab)
                // $key = $hsn . '_' . $rate . '_' . $cessRate;
                $key = $hsn . '_' . $rate;

                if (!isset($grouped[$key])) {
                    $grouped[$key] = [
                        'sale_id'       => $transaction['id'],
                        'hsn_code'      => $hsn,
                        'tax_rate'      => $rate,
                        'taxable_value' => 0,
                        'cgst_amount'   => 0,
                        'sgst_amount'   => 0,
                        'igst_amount'   => 0,
                        'cess_amount'   => 0,
                    ];
                }

                // Aggregate values
                $grouped[$key]['taxable_value'] += $item['gross_amount']??0;
                $grouped[$key]['cgst_amount']   += $cgst;
                $grouped[$key]['sgst_amount']   += $sgst;
                $grouped[$key]['igst_amount']   += $igst;
                // $grouped[$key]['cess_amount']   += $cess??0;

                Log::info($grouped);
            }

                        // Intra-state => CGST + SGST
            if ($transaction['place_of_supply_id'] == $organisation['state_id']) {

                $cgst_account=$this->get_accounts('output_c_g_s_t');
                $transaction_accounts->createTransaction($cgst_account['id'],$transaction,$transaction['customer_id'],'sales',StaticMaster::$SALE_TRANSACTION_TYPE,0,$transaction['total_tax']/2);
    
                $sgst_account=$this->get_accounts('output_s_g_s_t');
                $transaction_accounts->createTransaction($sgst_account['id'],$transaction,$transaction['customer_id'],'sales',StaticMaster::$SALE_TRANSACTION_TYPE,0,$transaction['total_tax']/2);
    
            } else {

                Log::info("Inter-state => IGST only");
                $igst_account=$this->get_accounts('output_i_g_s_t');
                $transaction_accounts->createTransaction($igst_account['id'],$transaction,$transaction['customer_id'],'sales',StaticMaster::$SALE_TRANSACTION_TYPE,0,$transaction['total_tax']);
        
            }

            // Save aggregated rows into DB
            foreach ($grouped as $row) {
                SaleItemTax::create($row);
            }
        }


        // All Account Entries done
        $transaction['is_accounting']=1;
        $transaction->update();

        return true;
    }

    // Credit Note Accounts Transactions Record ------------------------------------------------
    public function creditNote_accounts_transaction($transaction){
        
        //transaction object
        $transaction_accounts=new TransactionService;

        if($transaction['customer_id']>0){
            // Update User (Customer) balance 
            $customer=User::where('id',$transaction['customer_id'])->first();
            $customer['balance']=$customer['balance']-$transaction['total'];
            $customer->update();

            if($customer['account_id']>0){
                $transaction_accounts->createTransaction($customer['account_id'],$transaction,$transaction['customer_id'],'credit_note',StaticMaster::$CREDIT_NOTE,0,$transaction['total']);
            }else{
                // entry for receivables (Credit)
                $receivables=$this->get_accounts('accounts_receivable');
                $transaction_accounts->createTransaction($receivables['id'],$transaction,$transaction['customer_id'],'credit_note',StaticMaster::$CREDIT_NOTE,0,$transaction['total']);
            }
        }

        // entry for Sales (Revenue) (debit)
        $sale_account=$this->get_accounts('sales');
        $transaction_accounts->createTransaction($sale_account['id'],$transaction,$transaction['customer_id'],'credit_note',StaticMaster::$CREDIT_NOTE,$transaction['subtotal'],0);

        // entry for discount(Income) (Credit) 
        if($transaction['discount']>0){
            $discount_account=$this->get_accounts('discount');
            $transaction_accounts->createTransaction($discount_account['id'],$transaction,$transaction['customer_id'],'credit_note',StaticMaster::$CREDIT_NOTE,0,$transaction['discount']);
        }

        // entry for all the charges apply on Credit Notes behalf of Sales
        if(!is_null($transaction['charges']) && !empty($transaction['charges'])){

            // Convert the charges array to a JSON string
            $chargesJson = json_decode($transaction['charges'],true);

            if (!empty($chargesJson) && is_array($chargesJson)) {

                foreach ($chargesJson as $key => $value) {

                    if($value['account_id']>0){
                        //if amount is positive it will be displayed on Credit Side
                        if($value['amount']>=0){
                            $transaction_accounts->createTransaction($value['account_id'],$transaction,$transaction['customer_id'],'credit_note',StaticMaster::$CREDIT_NOTE,$value['amount'],0);
                        }else{
                            $transaction_accounts->createTransaction($value['account_id'],$transaction,$transaction['customer_id'],'credit_note',StaticMaster::$CREDIT_NOTE,0,$value['amount']);
                        }
                    }
                }
            }
        }

        // Calculate Taxes
        $user=Auth::user();

        $tax_type=Organisation::where('organisation_id',$user['active_organisation'])
            ->value('tax_type');

        // VAT Tax calculation
        if($tax_type==2){

            //Calculating VAT as tax type 2

            if($transaction['total_tax']>0){
                // Creating VAT Account in Tax Transaction
                $obj['transaction_id']=$transaction['id'];  //Credit id
                $obj['transaction_type']=StaticMaster::$CREDIT_NOTE;
                $obj['customer_id']=$transaction['customer_id']??0;
                $obj['vendor_id']=0;
                $obj['tax_type']=$tax_type;       //2 for VAT
                $obj['net_amount']=$transaction['total_gross_amount'];   //Amount before Tax
                $obj['tax_rate']=$transaction['tax_percent']??0;     //Vat Rate
                $obj['tax_amount']=$transaction['total_tax'];     // Calculated Tax
                $obj['gross_amount']=$transaction['total']; // Net + Tax
                $obj['hsn_code']=null;
                $obj['reference_id']=$transaction['id'];
                $obj['notes']=$transaction['notes'];

                $taxtransaction=TaxTransaction::create($obj);

                Log::info("VAT tax slab deducted for credit note");
                $vat_account=$this->get_accounts('output_v_a_t');
                $transaction_accounts->createTransaction($vat_account['id'],$transaction,$transaction['customer_id'],'credit_note',StaticMaster::$CREDIT_NOTE,$transaction['total_tax'],0);
            }
        }

        // GST Tax calculation
        if($tax_type==1){
            Log::info("GST tax slab deducted for credit note");
        }

        // All Account Entries done
        $transaction['is_accounting']=1;
        $transaction->update();

        return true;
    }

    // Purchases Accounts Transactions Record -----------------------------------------
    public function purchase_accounts_transaction($transaction){
        
        //Calling Bill Items
        $bill_items=BillItem::where('transaction_id',$transaction['id'])
            ->where('rolledback',0)
            ->get();

        $account_array = [];

        // Setting default account as inventory_asset and same account will have sum and tax amount
        foreach ($bill_items as $item) {
            //check if account_id is null then set default inventory_asset account
            if(empty($item['account_id'])) {
                $invt_account=$this->get_accounts('inventory_asset');
                $item['account_id'] = $invt_account['id'];
            }
            $accountId = $item['account_id'] ?? 0;
            $amount = $item['gross_amount'] ?? 0;

            if (isset($account_array[$accountId])) {
                $account_array[$accountId]['amount'] += $amount;
                $account_array[$accountId]['tax_amount'] += $item['tax_amount']??0;
            } else {
                $account_array[$accountId] = [
                    'account_id' => $accountId,
                    'amount'     => $amount,
                    'tax_amount' => $item['tax_amount']??0
                ];
            }
        }

        //transaction object
        $transaction_accounts=new TransactionService;

        $payable_id=0;
        $vendor=User::where('id',$transaction['vendor_id'])->first();

        if(isset($vendor['account_id']) && $vendor['account_id']>0){
            $payable_id=$vendor['account_id'];
            Log::info('Payable Account Id Vendor'.$payable_id);
        }else{
            //Setting default account as accounts_payable
            $payables=$this->get_accounts('accounts_payable');
            $payable_id=$payables['id'];
             Log::info('Payable Account Id Default'.$payable_id);
        }


        // If RCM is in a transaction Eligible
        if($transaction['is_rcm'] == 1){

            // When purchase is under RCM and input tax credit is allowed:
            // Purchase (Inventory / Expense) → Debit
            // Accounts Payable (Vendor) → Credit
            // RCM Payable (GST liability) → Credit
            // Input Tax Credit (GST recoverable) → Debit

            // Update Customer Account
            if($transaction['vendor_id']>0){

                // // total - total_tax
                // $payables=$this->get_accounts('accounts_payable');
                $transaction_accounts->createTransaction($payable_id,$transaction,$transaction['vendor_id'],'purchases',StaticMaster::$PURCAHSE_TRANSACTION_TYPE,0,($transaction['total'] - $transaction['total_tax'])??0);
            
                // Update User (Customer) balance 
                $vendor['balance']=$vendor['balance']+$transaction['total'];
                $vendor->update();
            }

            // Treatment of Asset account which is already set in asset master
            foreach ($account_array as $key => $value) {
                $transaction_accounts->createTransaction($value['account_id'],$transaction,$transaction['vendor_id'],'purchases',StaticMaster::$PURCAHSE_TRANSACTION_TYPE,$value['amount'],0);
            }
        
            // Treatment of GST Liability RCM Payable
            $rcm_payable=$this->get_accounts('r_c_m_payable');
            $transaction_accounts->createTransaction($rcm_payable['id'],$transaction,$transaction['vendor_id'],'purchases',StaticMaster::$PURCAHSE_TRANSACTION_TYPE,0,$transaction['total_tax']);

        }else if($transaction['is_rcm'] == 2){    // if Rcm is not Eligible

            // When purchase is not under RCM and input tax credit is not allowed:
            // Here ITC is not allowed, so the GST is expensed or added to cost (explained in my last message).
            if($transaction['vendor_id']>0){

                // total - total_tax
                // $payables=$this->get_accounts('accounts_payable');
                $transaction_accounts->createTransaction($payable_id,$transaction,$transaction['vendor_id'],'purchases',StaticMaster::$PURCAHSE_TRANSACTION_TYPE,0,($transaction['total'] - $transaction['total_tax'])??0);
            
                $vendor['balance']=$vendor['balance']+$transaction['total'];
                $vendor->update();
            }

            // Treatment of Asset account which is already set in asset master
            foreach ($account_array as $key => $value) {
                $transaction_accounts->createTransaction($value['account_id'],$transaction,$transaction['vendor_id'],'purchases',StaticMaster::$PURCAHSE_TRANSACTION_TYPE,$value['amount'] + $value['tax_amount'],0);
            }

            // Treatment of GST Liability RCM Payable
            $rcm_payable=$this->get_accounts('r_c_m_payable');
            $transaction_accounts->createTransaction($rcm_payable['id'],$transaction,$transaction['vendor_id'],'purchases',StaticMaster::$PURCAHSE_TRANSACTION_TYPE,0,$transaction['total_tax']);

        }else{
            //------------------------------ Normal forward charge case------------------------------------------

            // entry for Payables (Credit)
            if($transaction['vendor_id']>0){
                // $payables=$this->get_accounts('accounts_payable');  CR
                $transaction_accounts->createTransaction($payable_id,$transaction,$transaction['vendor_id'],'purchases',StaticMaster::$PURCAHSE_TRANSACTION_TYPE,0,$transaction['total']);
            
                // Update User (Customer) balance 
                $vendor['balance']=$vendor['balance']+$transaction['total'];
                $vendor->update();
            }

            //after discounted total amount will be deducted from inventory asset account
            // Treatment of Asset account which is already set in asset master
            foreach ($account_array as $key => $value) {
                if($transaction['input_tax']==1){    
                    $transaction_accounts->createTransaction($value['account_id'],$transaction,$transaction['vendor_id'],'purchases',StaticMaster::$PURCAHSE_TRANSACTION_TYPE,$value['amount'],0);

                }else{
                    $transaction_accounts->createTransaction($value['account_id'],$transaction,$transaction['vendor_id'],'purchases',StaticMaster::$PURCAHSE_TRANSACTION_TYPE,$value['amount'] + $value['tax_amount'],0);
                }
                
            }

            // entry for discount Received(Expense) (Credit) 
            if($transaction['discount']>0){
                $discount_account=$this->get_accounts('discount_received');
                $transaction_accounts->createTransaction($discount_account['id'],$transaction,$transaction['vendor_id'],'purchases',StaticMaster::$PURCAHSE_TRANSACTION_TYPE,0,$transaction['discount']??0);
            }

        }
        // entry for all the charges apply on Purchases will be under Expense
        if(!is_null($transaction['charges']) && !empty($transaction['charges'])){

            // Convert the charges array to a JSON string
            $chargesJson = json_decode($transaction['charges'],true);

            if (!empty($chargesJson) && is_array($chargesJson)) {

                Log::info($chargesJson);

                foreach ($chargesJson as $key => $value) {

                    if($value['account_id']>0){
                        //if amount is positive it will be displayed on Debit Side
                        if($value['amount']>0){
                            // amount is positive it will be displayed on Debit Side
                            $transaction_accounts->createTransaction($value['account_id'],$transaction,$transaction['vendor_id'],'purchases',StaticMaster::$PURCAHSE_TRANSACTION_TYPE,$value['amount']??0,0);
                        }else{
                            // amount is negative it will be displayed on Credit Side
                            $transaction_accounts->createTransaction($value['account_id'],$transaction,$transaction['vendor_id'],'purchases',StaticMaster::$PURCAHSE_TRANSACTION_TYPE,0,$value['amount']??0);
                        }
                    }
                    
                }
            }
        }

        // Calculate Taxes
        $user=Auth::user();

        $organisation=Organisation::where('organisation_id',$user['active_organisation'])
            ->first();

        $tax_type=$organisation['tax_type'];

        // GST Tax calculation
        if ($tax_type == 1) {
            Log::info("GST tax slab deducted");

            $grouped = [];

            if($transaction['is_rcm'] != 2 && $transaction['input_tax'] ==1){    // if Rcm is Eligible

                foreach ($bill_items as $item) {
                    $hsn      = $item['hsn_code'];
                    $rate     = $item['tax_rate'];   // GST % like 5, 12, 18
                    // $cessRate = $item['cess_rate'] ?? 0; // Optional cess %

                    $taxable = $item['quantity'] * $item['rate'];

                    Log::info("organisation state id :".$organisation['state_id']);

                    // Intra-state => CGST + SGST
                    if ($transaction['place_of_supply_id'] == $organisation['state_id']) {

                        Log::info("Intra-state => CGST + SGST");
                        $cgst = $item['tax_amount'] / 2;
                        $sgst = $item['tax_amount'] / 2;
                        $igst = 0;

                        $cgst_account=$this->get_accounts('input_c_g_s_t');
                        $transaction_accounts->createTransaction($cgst_account['id'],$transaction,$transaction['vendor_id'],'purchases',StaticMaster::$PURCAHSE_TRANSACTION_TYPE,$cgst,0);
            
                        $sgst_account=$this->get_accounts('input_s_g_s_t');
                        $transaction_accounts->createTransaction($sgst_account['id'],$transaction,$transaction['vendor_id'],'purchases',StaticMaster::$PURCAHSE_TRANSACTION_TYPE,$sgst,0);
            
                    } else {

                        Log::info("Inter-state => IGST only");
                        // Inter-state => IGST only
                        $cgst = 0;
                        $sgst = 0;
                        $igst = $item['tax_amount'];

                        $igst_account=$this->get_accounts('output_i_g_s_t');
                        $transaction_accounts->createTransaction($igst_account['id'],$transaction,$transaction['vendor_id'],'purchases',StaticMaster::$PURCAHSE_TRANSACTION_TYPE,$igst,0);
                
                    }

                    // CESS calculation
                    // $cess = $cessRate > 0 ? $taxable * ($cessRate / 100) : 0;

                    // Unique key for grouping (HSN + GST slab + cess slab)
                    // $key = $hsn . '_' . $rate . '_' . $cessRate;
                    $key = $hsn . '_' . $rate;

                    if (!isset($grouped[$key])) {
                        $grouped[$key] = [
                            'sale_id'       => $transaction['id'],
                            'hsn_code'      => $hsn,
                            'tax_rate'      => $rate,
                            'taxable_value' => 0,
                            'cgst_amount'   => 0,
                            'sgst_amount'   => 0,
                            'igst_amount'   => 0,
                            'cess_amount'   => 0,
                        ];
                    }

                    // Aggregate values
                    $grouped[$key]['taxable_value'] += $item['gross_amount']??0;
                    $grouped[$key]['cgst_amount']   += $cgst;
                    $grouped[$key]['sgst_amount']   += $sgst;
                    $grouped[$key]['igst_amount']   += $igst;
                    // $grouped[$key]['cess_amount']   += $cess??0;

                    Log::info($grouped);
                }

                // Intra-state => CGST + SGST
                if ($transaction['place_of_supply_id'] == $organisation['state_id']) {

                    $cgst_account=$this->get_accounts('input_c_g_s_t');
                    $transaction_accounts->createTransaction($cgst_account['id'],$transaction,$transaction['vendor_id'],'purchases',StaticMaster::$PURCAHSE_TRANSACTION_TYPE,$transaction['total_tax']/2,0);
        
                    $sgst_account=$this->get_accounts('input_s_g_s_t');
                    $transaction_accounts->createTransaction($sgst_account['id'],$transaction,$transaction['vendor_id'],'purchases',StaticMaster::$PURCAHSE_TRANSACTION_TYPE,$transaction['total_tax']/2,0);
        
                } else {

                    $igst_account=$this->get_accounts('output_i_g_s_t');
                    $transaction_accounts->createTransaction($igst_account['id'],$transaction,$transaction['vendor_id'],'purchases',StaticMaster::$PURCAHSE_TRANSACTION_TYPE,$transaction['total_tax'],0);
            
                }

                // Save aggregated rows into DB
                foreach ($grouped as $row) {
                    PurchaseItemTax::create($row);
                }
            }
        }

        // VAT Tax calculation
        if($tax_type==2){

            //Calculating VAT as tax type 2
            if($transaction['total_tax']>0 && $transaction['input_tax']==1){
                // Creating VAT Account in Tax Transaction
                $obj['transaction_id']=$transaction['id'];  //purchase id
                $obj['transaction_type']=StaticMaster::$PURCAHSE_TRANSACTION_TYPE;
                $obj['vendor_id']=$transaction['vendor_id']??0;
                $obj['customer_id']=0;
                $obj['tax_type']=$tax_type;       //2 for VAT
                $obj['net_amount']=$transaction['total_gross_amount'];   //Amount before Tax
                $obj['tax_rate']=$transaction['tax_percent']??0;     //Vat Rate
                $obj['tax_amount']=$transaction['total_tax'];     // Calculated Tax
                $obj['gross_amount']=$transaction['total']; // Net + Tax
                $obj['hsn_code']=null;
                $obj['reference_id']=$transaction['id'];
                $obj['notes']=$transaction['notes'];

                $taxtransaction=TaxTransaction::create($obj);

                if($transaction['is_rcm']!=2 || $transaction['input_tax']==1){
                    Log::info("VAT tax slab deducted for credit note");    
                    $vat_account=$this->get_accounts('input_v_a_t');
                    $transaction_accounts->createTransaction($vat_account['id'],$transaction,$transaction['vendor_id'],'purchases',StaticMaster::$PURCAHSE_TRANSACTION_TYPE,$transaction['total_tax'],0);
                }
        
            }
        }

        // All Account Entries done
        $transaction['is_accounting']=1;
        $transaction->update();

        return true;
    }

    // Debit Note Accounts Transactions Record -----------------------------------------
    public function debitNote_accounts_transaction($transaction){
    //Calling Bill Items
        $bill_items=BillItem::where('transaction_id',$transaction['id'])
            ->where('rolledback',0)
            ->get();

        $account_array = [];

        // Setting default account as inventory_asset and same account will have sum and tax amount
        foreach ($bill_items as $item) {
            //check if account_id is null then set default inventory_asset account
            if(empty($item['account_id'])) {
                $invt_account=$this->get_accounts('inventory_asset');
                $item['account_id'] = $invt_account['id'];
            }
            $accountId = $item['account_id'] ?? 0;
            $amount = $item['gross_amount'] ?? 0;

            if (isset($account_array[$accountId])) {
                $account_array[$accountId]['amount'] += $amount;
                $account_array[$accountId]['tax_amount'] += $item['tax_amount']??0;
            } else {
                $account_array[$accountId] = [
                    'account_id' => $accountId,
                    'amount'     => $amount,
                    'tax_amount' => $item['tax_amount']??0
                ];
            }
        }

        //transaction object
        $transaction_accounts=new TransactionService;

        $payable_id=0;

        $vendor=User::where('id',$transaction['vendor_id'])->first();

        if(isset($vendor['account_id']) && $vendor['account_id']>0){
            $payable_id=$vendor['account_id'];
            Log::info('Payable Account Id Vendor'.$payable_id);
        }else{
            //Setting default account as accounts_payable
            $payables=$this->get_accounts('accounts_payable');
            $payable_id=$payables['id'];
             Log::info('Payable Account Id Default'.$payable_id);
        }

        // entry for Payables (debit)
        $transaction_accounts->createTransaction($payable_id,$transaction,$transaction['vendor_id'],'debit_note',StaticMaster::$DEBIT_NOTE,$transaction['total'],0);

        // Update User (Customer) balance 
        $vendor['balance']=$vendor['balance'] - $transaction['total'];
        $vendor->update();

        // entry for Cost of goods Sold (Expense) (Credit)
        foreach ($account_array as $key => $value) {
            Log::info('Debit Note Account COGS');
            Log::info($value);
            $transaction_accounts->createTransaction($value['account_id'],$transaction,$transaction['vendor_id'],'debit_note',StaticMaster::$DEBIT_NOTE,0,$value['amount']);
        }
        // entry for discount Received(Expense) (Debit) 
        if($transaction['discount']>0){
            $discount_account=$this->get_accounts('discount_received');
            $transaction_accounts->createTransaction($discount_account['id'],$transaction,$transaction['vendor_id'],'debit_note',StaticMaster::$DEBIT_NOTE,$transaction['discount'],0);
        }

        // entry for all the charges apply on Purchases will be under Expense
        if(!is_null($transaction['charges']) && !empty($transaction['charges'])){

            // Convert the charges array to a JSON string
            $chargesJson = json_decode($transaction['charges'],true);

            if (!empty($chargesJson) && is_array($chargesJson)) {

                Log::info($chargesJson);

                foreach ($chargesJson as $key => $value) {

                    if($value['account_id']>0){
                        //if amount is positive it will be displayed on Debit Side
                        if($value['amount']>0){
                            // amount is positive it will be displayed on Credit Side
                            $transaction_accounts->createTransaction($value['account_id'],$transaction,$transaction['vendor_id'],'debit_note',StaticMaster::$DEBIT_NOTE,0,$value['amount']);
                        }else{
                            // amount is negative it will be displayed on Debit Side
                            $transaction_accounts->createTransaction($value['account_id'],$transaction,$transaction['vendor_id'],'debit_note',StaticMaster::$DEBIT_NOTE,$value['amount'],0);
                        }
                    }
                }
            }
        }

        // Calculate Taxes
        $user=Auth::user();

        $tax_type=Organisation::where('organisation_id',$user['active_organisation'])
            ->value('tax_type');

        Log::info("tax type :".$tax_type);

        // VAT Tax calculation
        if($tax_type==2){

            //Calculating VAT as tax type 2

            if($transaction['total_tax']>0){
                // Creating VAT Account in Tax Transaction
                $obj['transaction_id']=$transaction['id'];  //DEBIT_NOTE id
                $obj['transaction_type']=StaticMaster::$DEBIT_NOTE;
                $obj['customer_id']=$transaction['customer_id']??0;
                $obj['vendor_id']=0;
                $obj['tax_type']=$tax_type;       //2 for VAT
                $obj['net_amount']=$transaction['total_gross_amount'];   //Amount before Tax
                $obj['tax_rate']=$transaction['tax_percent']??0;     //Vat Rate
                $obj['tax_amount']=$transaction['total_tax'];     // Calculated Tax
                $obj['gross_amount']=$transaction['total']; // Net + Tax
                $obj['hsn_code']=null;
                $obj['reference_id']=$transaction['id'];
                $obj['notes']=$transaction['notes'];

                $taxtransaction=TaxTransaction::create($obj);

                Log::info("VAT tax slab deducted for credit note"); 
                $vat_account=$this->get_accounts('input_v_a_t');
                $transaction_accounts->createTransaction($vat_account['id'],$transaction,$transaction['vendor_id'],'debit_note',StaticMaster::$DEBIT_NOTE,0,$transaction['total_tax']);
            
            }
        }

        // GST Tax calculation
        if($tax_type==1){
            Log::info("GST tax slab deducted");
        }

        // All Account Entries done
        $transaction['is_accounting']=1;
        $transaction->update();

        return true;
    }
    
    // Expense Accouts Transaction Records-------------------------------------------------
    public function expense_accounts_transaction($transaction){
        //transaction object
        $transaction_accounts=new TransactionService;

        $party_id = $transaction['customer_id'] ?? $transaction['vendor_id'] ?? 0;

        //Entry of Expense Account Record
        if($transaction['paid_by']>0){
            //Entry of Expense Account Record

            if($transaction['tax_amount']>0){

                // If Input Tax is Eligible
                if($transaction['input_tax']==1){
                    //Entry of Expense Account Record with tax amount (DR)
                    $transaction_accounts->createTransaction($transaction['acc_id'],$transaction,$party_id,'expense',StaticMaster::$EXPENSE,$transaction['amount']-$transaction['tax_amount'],0);

                    // Entry of Tax Account Record (DR)
                    $vat_account=$this->get_accounts('input_v_a_t');
                    $transaction_accounts->createTransaction($vat_account['id'],$transaction,$party_id,'expense',StaticMaster::$EXPENSE,$transaction['tax_amount'],0);
                }else{
                    //Entry of Expense Account Record with tax amount (DR)
                    $transaction_accounts->createTransaction($transaction['acc_id'],$transaction,$party_id,'expense',StaticMaster::$EXPENSE,$transaction['amount'],0);
                }

            }else{
                //Normal senerio Entry of Expense Account Record (DR)
                $transaction_accounts->createTransaction($transaction['acc_id'],$transaction,$party_id,'expense',StaticMaster::$EXPENSE,$transaction['amount'],0);
            }
            
            // Paid By in full Amount (CR)
            $transaction_accounts->createTransaction($transaction['paid_by'],$transaction,$party_id,'expense',StaticMaster::$EXPENSE,0,$transaction['amount']);
        
        }else{

           if($transaction['tax_amount']>0){
                //Entry of Expense Account Record with tax amount (DR)
                $transaction_accounts->createTransaction($transaction['acc_id'],$transaction,$party_id,'expense',StaticMaster::$EXPENSE,$transaction['amount']-$transaction['tax_amount'],0);

                // Entry of Tax Account Record (DR)
                $vat_account=$this->get_accounts('input_v_a_t');
                $transaction_accounts->createTransaction($vat_account['id'],$transaction,$party_id,'expense',StaticMaster::$EXPENSE,$transaction['tax_amount'],0);

            }else{
                //Normal senerio Entry of Expense Account Record (DR)
                $transaction_accounts->createTransaction($transaction['acc_id'],$transaction,$party_id,'expense',StaticMaster::$EXPENSE,$transaction['amount'],0);
            }

            // Party
            $transaction_accounts->createTransaction($party_id,$transaction,$party_id,'expense',StaticMaster::$EXPENSE,0,$transaction['amount']);
            
            // Update User (Customer) balance 
            $party = User::find($party_id);
            if ($party) {
                if (!empty($transaction['vendor_id'])) {
                    // Vendor (Payable ↑)
                    $party->balance += $transaction['amount'];
                } elseif (!empty($transaction['customer_id'])) {
                    // Customer (Receivable ↓)
                    $party->balance -= $transaction['amount'];
                }
                $party->save();
            }
        }
       
        // All Account Entries done
        $transaction['is_accounting']=1;
        $transaction->update();

        return true; 
    }

    public function payment_account_transaction($transaction){

        //transaction object
        $transaction_accounts=new TransactionService;

        // Update User (Customer) balance 
        if($transaction['customer_id']>0){
            $customer=User::where('id',$transaction['customer_id'])->first();
            if($transaction['debit']>0){
                $customer['balance']=$customer['balance']-$transaction['debit'];
            }
            if($transaction['credit']>0){
                $customer['balance']=$customer['balance']+$transaction['credit'];
            }
            $customer->update();
        }
        if($transaction['vendor_id'] >0){
            $vendor=User::where('id',$transaction['vendor_id'])->first();
            if($transaction['debit']>0){
                $vendor['balance']=$vendor['balance']+$transaction['debit'];
            }
            if($transaction['credit']>0){
                $vendor['balance']=$vendor['balance']-$transaction['credit'];
            }
            $vendor->update();
        }
        // Check if a payment is done against Invoice or bill
        $against_payment=AgainstPayment::where('payment_id',$transaction['id'])->get();

        if ($against_payment->isNotEmpty()) {

            // If overpayment and amount in excess
            if($transaction['amt_excess']>0){

                if($transaction['entity_type']==StaticMaster::$SALE_TRANSACTION_TYPE){

                    //Excess Deposit A/c will (debit)
                    $transaction_accounts->createTransaction($transaction['to_acc'],$transaction,$transaction['customer_id'],'customer_payment',StaticMaster::$PAYMENTS_RECEIVED,$transaction['amt_excess'],0);

                    // Entry to a Customer Account (Credit)
                    $receivables=$this->get_accounts('accounts_receivable');
                    $transaction_accounts->createTransaction($receivables['id'],$transaction,$transaction['customer_id'],'customer_payment',StaticMaster::$PAYMENTS_RECEIVED,0,$transaction['amt_excess']);
                
                }

                if($transaction['entity_type']==StaticMaster::$PURCAHSE_TRANSACTION_TYPE){

                    // Entry to a Vendor Account (debit)
                    $payables=$this->get_accounts('accounts_payable');
                    $transaction_accounts->createTransaction($payables['id'],$transaction,$transaction['vendor_id'],'vendor_payment',StaticMaster::$PAYMENTS_MADE,$transaction['amt_excess'],0);

                    //Purchase Deposit A/c will (credit)
                    $transaction_accounts->createTransaction($transaction['to_acc'],$transaction,$transaction['vendor_id'],'vendor_payment',StaticMaster::$PAYMENTS_MADE,0,$transaction['amt_excess']);
                }

            }
            
            // It is treated as Payment is adjusted on invoice bases
            foreach ($against_payment as $payment) {

                // Perform operations with $payment
                if(isset($payment['invoice_id']) && $payment['invoice_id']!=0 && $payment['invoice_id']!=''){

                    $invoice=Invoice::where('id',$payment['invoice_id'])->first();
                    $invoice['amount_paid']=intval($invoice['amount_paid']) + $payment['amount'];
                    $invoice->update();

                    //Invoice Deposit A/c will (debit)
                    $transaction_accounts->create_against_payment_Transaction($transaction['to_acc'],$transaction,$payment,'invoice_payment',StaticMaster::$INVOICE_PAYMENT,$payment['amount'],0);

                    // Entry to a Customer Account (Credit)
                    $receivables=$this->get_accounts('accounts_receivable');
                    $transaction_accounts->create_against_payment_Transaction($receivables['id'],$transaction,$payment,'invoice_payment',StaticMaster::$INVOICE_PAYMENT,0,$payment['amount']);

                }
    
                if(isset($payment['bill_id']) && $payment['bill_id']!=0 && $payment['bill_id']!=''){

                    $bill=Bill::where('id',$payment['bill_id'])->first();
                    $bill['amount_paid']=intval($bill['amount_paid']) + $payment['amount'];
                    $bill->update();

                    // Entry to a Vendor Account (Debit)
                    $payables=$this->get_accounts('accounts_payable');
                    $transaction_accounts->create_against_payment_Transaction($payables['id'],$transaction,$payment,'bill_payment',StaticMaster::$BILL_PAYMENT,$payment['amount'],0);

                    //Purchase Deposit A/c will (Credit)
                    $transaction_accounts->create_against_payment_Transaction($transaction['to_acc'],$transaction,$payment,'bill_payment',StaticMaster::$BILL_PAYMENT,0,$payment['amount']);

                }   


            }
        } else {
            // No record found means payment is overpay or advance pay or paying on account of cutomer or vendor

            if($transaction['entity_type']==StaticMaster::$SALE_TRANSACTION_TYPE){

                //Excess Deposit A/c will (debit)
                $transaction_accounts->createTransaction($transaction['to_acc'],$transaction,$transaction['customer_id'],'customer_payment',StaticMaster::$PAYMENTS_RECEIVED,$transaction['debit'],0);

                // Entry to a Customer Account (Credit)
                $receivables=$this->get_accounts('accounts_receivable');
                $transaction_accounts->createTransaction($receivables['id'],$transaction,$transaction['customer_id'],'customer_payment',StaticMaster::$PAYMENTS_RECEIVED,0,$transaction['debit']);
            
            }

            if($transaction['entity_type']==StaticMaster::$PURCAHSE_TRANSACTION_TYPE){

                // Entry to a Vendor Account (debit)
                $payables=$this->get_accounts('accounts_payable');
                $transaction_accounts->createTransaction($payables['id'],$transaction,$transaction['vendor_id'],'vendor_payment',StaticMaster::$PAYMENTS_MADE,$transaction['credit'],0);

                //Purchase Deposit A/c will (credit)
                $transaction_accounts->createTransaction($transaction['from_acc'],$transaction,$transaction['vendor_id'],'vendor_payment',StaticMaster::$PAYMENTS_MADE,0,$transaction['credit']);
            }

            if($transaction['entity_type']==StaticMaster::$CREDIT_NOTE){

                // Entry to a Customer Account (debit)
                $payables=$this->get_accounts('accounts_receivable');
                $transaction_accounts->createTransaction($payables['id'],$transaction,$transaction['customer_id'],'customer_payment',StaticMaster::$CREDIT_NOTE_PAYMENT,$transaction['credit'],0);

                //Purchase Deposit A/c will (credit)
                $transaction_accounts->createTransaction($transaction['from_acc'],$transaction,$transaction['customer_id'],'customer_payment',StaticMaster::$CREDIT_NOTE_PAYMENT,0,$transaction['credit']);
            }

            if($transaction['entity_type']==StaticMaster::$DEBIT_NOTE){

                //Purchase Deposit A/c will (Debit)
                $transaction_accounts->createTransaction($transaction['to_acc'],$transaction,$transaction['vendor_id'],'vendor_payment',StaticMaster::$DEBIT_NOTE_PAYMENT,$transaction['debit'],0);
                
                // Entry to a Vendor Account (credit)
                $payables=$this->get_accounts('accounts_payable');
                $transaction_accounts->createTransaction($payables['id'],$transaction,$transaction['vendor_id'],'vendor_payment',StaticMaster::$DEBIT_NOTE_PAYMENT,0,$transaction['debit']);

            }

        }

        // All Account Entries done
        $transaction['is_accounting']=1;
        $transaction->update();
    }

    // Supplier Account Entries For DSR
    public function dsr_supplier_account_transaction($transaction,$dsr_details){
        //here the transaction will be single servie like hotel , assists , flights , etc
        //$transaction include columns like supplier_id , gross_amount, charges , supplier_amount, supplier_tax, supplier_total.
           
        //transaction object
        $transaction_accounts=new TransactionService;

        // entry for Payables (Credit)
        $payables=$this->get_accounts('accounts_payable');
        $transaction_accounts->dsr_mice_createTransaction($payables['id'],$transaction,$dsr_details,$transaction['supplier_id'],'dsr',StaticMaster::$DSR_TYPE,0,$transaction['supplier_total']);

        // Update User (Customer) balance 
        $customer = User::find($transaction['supplier_id']);
        if ($customer) {
            $customer->balance += $transaction['supplier_total']??0;
            $customer->save();
        }

        // entry for Cost of goods Sold (Expense) (Debit)
        $purchase_account=$this->get_accounts('cost_of_goods_sold');
        $transaction_accounts->dsr_mice_createTransaction($purchase_account['id'],$transaction,$dsr_details,$transaction['supplier_id'],'dsr',StaticMaster::$DSR_TYPE,$transaction['gross_amount'],0);

        // entry for discount Received(Expense) (Credit) 
        if($transaction['discount']>0){
            $discount_account=$this->get_accounts('discount_received');
            $transaction_accounts->dsr_mice_createTransaction($discount_account['id'],$transaction,$dsr_details,$transaction['supplier_id'],'dsr',StaticMaster::$DSR_TYPE,0,$transaction['discount']);
        }

        // entry for all the charges apply on Supplier in DSR will be under Expense
        if(!is_null($transaction['charges']) && !empty($transaction['charges'])){

            // Convert the charges array to a JSON string
            $chargesJson = json_decode($transaction['charges'],true);

            if (!empty($chargesJson) && is_array($chargesJson)) {

                Log::info($chargesJson);

                foreach ($chargesJson as $key => $value) {

                    //if amount is positive it will be displayed on Debit Side
                    if($value['amount']>0){
                        // amount is positive it will be displayed on Debit Side
                        $transaction_accounts->dsr_mice_createTransaction($value['account_id'],$transaction,$dsr_details,$transaction['supplier_id'],'dsr',StaticMaster::$DSR_TYPE,$value['amount'],0);
                    }else{
                        // amount is negative it will be displayed on Credit Side
                        $transaction_accounts->dsr_mice_createTransaction($value['account_id'],$transaction,$dsr_details,$transaction['supplier_id'],'dsr',StaticMaster::$DSR_TYPE,0,$value['amount']);
                    }
                    
                }
            }
        }

        // Calculate Taxes
        $user=Auth::user();

        $tax_type=Organisation::where('organisation_id',$user['active_organisation'])
            ->value('tax_type');

        Log::info("tax type :".$tax_type);

        // VAT Tax calculation
        if($tax_type==2){

            //Calculating VAT as tax type 2
            Log::info("VAT tax slab deducted");
            $vat_account=$this->get_accounts('input_v_a_t');
            $transaction_accounts->dsr_mice_createTransaction($vat_account['id'],$transaction,$dsr_details,$transaction['supplier_id'],'dsr',StaticMaster::$DSR_TYPE,$transaction['supplier_tax'],0);
        }
   
        // GST Tax calculation
        if($tax_type==1){
            Log::info("GST tax slab deducted");
        }

        // All Account Entries done
        $transaction['is_accounting']=1;
        $transaction->update();

        return true;
    }

    // Customer Account Entries For DSR full total amount settle
    public function dsr_customer_account_transaction($transaction){
        //$transaction include columns like customer_id , total_final_amount,total_tax_amount,total_retain_amount,total_gross_amount.

        //transaction object
        $transaction_accounts=new TransactionService;

        // entry for receivables (Debit)
        $receivables=$this->get_accounts('accounts_receivable');
        $transaction_accounts->dsr_mice_customer_createTransaction($receivables['id'],$transaction,$transaction['customer_id'],'dsr',StaticMaster::$DSR_TYPE,$transaction['total_final_amount'],0);
 
         // Update User (Customer) balance 
        $customer = User::find($transaction['customer_id']);
        if ($customer) {
            $customer->balance += $transaction['total_final_amount'];
            $customer->save();
        }
 
         // entry for Sales (Revenue) (Credit)
         
        $sale_account=$this->get_accounts('sales');
        $transaction_accounts->dsr_mice_customer_createTransaction($sale_account['id'],$transaction,$transaction['customer_id'],'dsr',StaticMaster::$DSR_TYPE,0,$transaction['total_gross_amount']);

        // entry for discount(Income) (Debit) 
        if($transaction['discount']>0){
            $discount_account=$this->get_accounts('discount');
            $transaction_accounts->dsr_mice_customer_createTransaction($discount_account['id'],$transaction,$transaction['customer_id'],'dsr',StaticMaster::$DSR_TYPE,$transaction['discount'],0);
        }

        

        return true;
    }

    public function dsr_customer_vat_account_transaction($transaction,$dsr_details){
        //here the transaction will be single servie like hotel , assists , flights , etc
        //$transaction include columns like supplier_id, gross_amount , tax_percent, tax_amount,retain,supplier_amount,Supplier_total,total_amount,charges.   
        //$dsr_details include columns like transaction_id, service,passenger_name, invoice_no,customer_id.
        
        // Calculate Taxes
        $user=Auth::user();

         //transaction object
         $transaction_accounts=new TransactionService;

        $tax_type=Organisation::where('organisation_id',$user['active_organisation'])
            ->value('tax_type');

        Log::info("tax type :".$tax_type);

        // VAT Calculation & Entry
        if ($tax_type == 2) { // VAT Applicable
            Log::info("Applying VAT Calculation");

            // Ensure total_tax_amount is properly calculated
            $vat_amount = $transaction['tax_amount'] ?? 0;

            if ($vat_amount > 0) {

                // Creating VAT Account in Tax Transaction
                $obj['transaction_id']=$dsr_details['transaction_id'];  //Dsr id
                $obj['transaction_type']=StaticMaster::$DSR_TYPE;
                $obj['customer_id']=$dsr_details['customer_id']??0;
                $obj['vendor_id']=0;
                $obj['tax_type']=$tax_type;       //2 for VAT
                $obj['net_amount']=$transaction['gross_amount'];   //Amount before Tax
                $obj['tax_rate']=$transaction['tax_percent'];     //Vat Rate
                $obj['tax_amount']=$transaction['tax_amount'];     // Calculated Tax
                $obj['gross_amount']=$transaction['total_amount']; // Net + Tax
                $obj['hsn_code']=null;
                $obj['reference_id']=$transaction['id'];
                $obj['notes']=$dsr_details['service'].' Service under passenger "'.$dsr_details['passenger_name'].'" having Invoice No.="'.$dsr_details['invoice_no'].'"';

                $taxtransaction=TaxTransaction::create($obj);

                // VAT Account Entry
                $vat_account = $this->get_accounts('output_v_a_t');
                $transaction_accounts->dsr_mice_vat_customer_createTransaction($vat_account['id'], $transaction,$dsr_details, $dsr_details['customer_id'],
                    'dsr', StaticMaster::$DSR_TYPE, 0, $vat_amount);
            }
        }

        // GST Tax calculation
        if($tax_type==1){
            Log::info("GST tax slab deducted");
        }

        return true;
    }
}


