<?php

namespace App\Service;
use DB;
use App\Models\User;
use App\Models\DebitNoteItem;
use App\Models\CreditNoteItem;
use App\Models\InvoiceItem;
use App\Models\Invoice;
use App\Models\Bill;
use App\Models\BillItem;
use Log;

class CreditDebitItemService
{

    public function saveItems($request,$transaction){
        
        foreach ($request['items'] as $key => $item) {
            
            $obj['item_id']=$item['item_id']??0;
            $obj['item_name']=$item['item_name']??null;
            $obj['quantity']=$item['quantity']??0;
            $obj['unit_id']=$item['unit_id']??0;
            $obj['rate']=$item['rate']??0;
            $obj['gross_amount']=$item['gross_amount']??0;
            $obj['tax_rate']=$item['tax_rate']??0;
            $obj['tax_amount']=$item['tax_amount']??0;
            $obj['discount_type']=$item['discount_type']??0;
            $obj['discount']=$item['discount']??0;
            $obj['final_amount']=$item['final_amount']??0;
            $obj['item_remark']=$item['item_remark']??null;
            $obj['type']=$item['type']??null;            //Product , Service , Raw Materials
            $obj['is_service']=$item['is_service']??0;
            $obj['service_data']=$item['service_data']??null;
            $obj['reason_type']=$item['reason_type']??null;
            $obj['reason_diff']=$item['reason_diff']??1;     // 1 for stock , 2 for only rate difference

            $obj['transaction_id']=$transaction['id'];

            if($request['tran_type']=='credit_note'){

                $saleItem=CreditNoteItem::create($obj);

                //update the credit note quantity in invoice item table
                if($obj['type']=='Service' || $obj['is_service']==1){
                    $invoice_item=InvoiceItem::where('transaction_id',$transaction['invoice_id'])->where('is_disabled',0)
                        ->where('item_name',$obj['item_name'])
                        ->first();
                }else{
                    $invoice_item=InvoiceItem::where('transaction_id',$transaction['invoice_id'])->where('is_disabled',0)
                        ->where('item_id',$obj['item_id'])
                        ->first();
                }

                if($invoice_item !=null){
                    $invoice_item->credit_note_qty= $invoice_item->credit_note_qty + $obj['quantity'];
                    $invoice_item->update();
                }

                
                //check if invoce is paid then update the status to paid
                $invoice_items_count=InvoiceItem::where('transaction_id',$transaction['invoice_id'])
                    ->where('is_disabled',0)->sum('quantity');

                $count_credit_invoice=InvoiceItem::where('transaction_id',$transaction['invoice_id'])
                    ->where('is_disabled',0)->sum('credit_note_qty');

                if($invoice_items_count == $count_credit_invoice){

                    $invoice=Invoice::where('id',$transaction['invoice_id'])->first();
                    $invoice->is_credit_note_close=1;
                    $invoice->update();
                }else{
                    $invoice=Invoice::where('id',$transaction['invoice_id'])->first();
                    $invoice->is_credit_note_close=0;
                    $invoice->update();
                }
                
            }

            if($request['tran_type']=='debit_note'){

                $saleItem=DebitNoteItem::create($obj);

                //update the credit note quantity in invoice item table
                if($obj['type']=='Service' || $obj['is_service']==1){
                     $bill_item=BillItem::where('transaction_id',$transaction['bill_id'])->where('rolledback',0)
                        ->where('item_name',$obj['item_name'])
                        ->first();
                }else{
                     $bill_item=BillItem::where('transaction_id',$transaction['bill_id'])->where('rolledback',0)
                        ->where('item_id',$obj['item_id'])
                        ->first();
                }

                if($bill_item !=null){
                    $bill_item->debit_note_qty= $bill_item->debit_note_qty + $obj['quantity'];
                    $bill_item->update();
                }

                 //check if invoce is paid then update the status to paid
                $bill_items_count=BillItem::where('transaction_id',$transaction['bill_id'])
                    ->where('rolledback',0)->sum('quantity');

                $count_debit_bill=BillItem::where('transaction_id',$transaction['bill_id'])
                    ->where('rolledback',0)->sum('debit_note_qty');

                if($bill_items_count == $count_debit_bill){

                    $bill=Bill::where('id',$transaction['bill_id'])->first();
                    $bill->is_debit_note_close=1;
                    $bill->update();
                }else{
                    $bill=Bill::where('id',$transaction['bill_id'])->first();
                    $bill->is_debit_note_close=0;
                    $bill->update();
                }
            }

            $transaction['total_tax']=$transaction['total_tax'] +  (isset($obj['tax_amount']) ? $obj['tax_amount'] : 0);
            $transaction['total_gross_amount']=$transaction['total_gross_amount'] + (isset($obj['gross_amount']) ? $obj['gross_amount'] : 0);

        }

        
        $transaction->update();

        return true;
        
    }
}