<?php

namespace App\Service;
use Carbon\Carbon;
use App\Models\SaleTransaction;
use App\Models\StockTransaction;
use App\Models\DailyStock;
use Auth;
use App\Models\User;
use Log;

class DailyService
{
    public function updateNextDayStockStatus($stockTransaction){
        $user = Auth::user();
        if(!isset($stockTransaction['transaction_date']) || $stockTransaction['transaction_date']==null || $stockTransaction['transaction_date']=="null"){
            $stockTransaction['transaction_date']=Carbon::today()->format('Y-m-d');
            $stockTransaction->update();
            //dd($stockTransaction);
            $stockTransaction=StockTransaction::where('id',$stockTransaction['id'])->first();
        }
        
        $nextdate = Carbon::createfromformat('Y-m-d',$stockTransaction['transaction_date'])->addDay(1);

        $nextDayNumberObject = DailyStock::where('dailydate',$nextdate->format('Y-m-d'))
            ->where('item_id',$stockTransaction['item_id'])
            ->where('warehouse_id',$stockTransaction['warehouse_id'])
            ->where('fy',$stockTransaction['fy'])
            ->where('vendorid',$stockTransaction['vendorid']==null?0:$stockTransaction['vendorid'])->first();
        
        // if($stockTransaction['rolledback']==1 && $stockTransaction['trantype']==10 && $nextDayNumberObject!=null){
        //     $nextDayNumberObject->delete();
        //     $nextDayNumberObject = null;
        // }

        if($nextDayNumberObject==null){
            $dailyinnerdate = DailyStock::where('dailydate','<=',$stockTransaction['transaction_date'])
            ->where('item_id',$stockTransaction['item_id'])
            ->where('warehouse_id',$stockTransaction['warehouse_id'])
            ->where('fy',$stockTransaction['fy'])
            ->where('vendorid',$stockTransaction['vendorid']==null?0:$stockTransaction['vendorid'])
            ->orderby('dailydate','desc')
            ->first();
            
            $obj['quantity']=$dailyinnerdate['quantity']??0;
            $obj['dailydate']=$nextdate->format('Y-m-d');
            $obj['item_id']=$stockTransaction['item_id'];
            $obj['warehouse_id']=$stockTransaction['warehouse_id'];
            $obj['fy']=$stockTransaction['fy'];
            $obj['vendorid']=$stockTransaction['vendorid']==null?0:$stockTransaction['vendorid'];
            if($stockTransaction['trantype']==10)
                $obj['modified']=1;
            $nextDayNumberObject = DailyStock::create($obj);
        }
        
      
        if($stockTransaction['inout']==1 && $stockTransaction['rolledback']==0){
            $nextDayNumberObject['quantity']=$nextDayNumberObject['quantity'] + $stockTransaction['quantity'];
        } else if ($stockTransaction['inout']==1 && $stockTransaction['rolledback']==1 ){
            $nextDayNumberObject['quantity']=$nextDayNumberObject['quantity'] - $stockTransaction['quantity'];
        } else if ($stockTransaction['inout']==2 && $stockTransaction['rolledback']==0){
            $nextDayNumberObject['quantity']=$nextDayNumberObject['quantity'] - $stockTransaction['quantity'];
        } else if ($stockTransaction['inout']==2 && $stockTransaction['rolledback']==1){
            $nextDayNumberObject['quantity']=$nextDayNumberObject['quantity'] + $stockTransaction['quantity'];
        }
        //$nextDayNumberObject['quantity']=$newstartno;
        $nextDayNumberObject->update();

        if($stockTransaction['inout']==1)
            $increment = $stockTransaction['quantity'];
        else
            $increment = $stockTransaction['quantity'] * -1;

        if($stockTransaction['rolledback']==0)
            $increment =$increment;
        else
            $increment =$increment * -1;
        //dd($increment);
        $todaydatecarbon = Carbon::createfromformat('Y-m-d',$stockTransaction['transaction_date'])->addDay(1);
    
        $modifiedDate=null;
        if($modifiedDate==null){
            //dd($increment);
            $todaydatecarbon = Carbon::createfromformat('Y-m-d',$stockTransaction['transaction_date'])->addDay(2);
            $stocks = DailyStock::where('dailydate','>',$todaydatecarbon->format('Y-m-d'))
            ->where('item_id',$stockTransaction['item_id'])
            ->where('warehouse_id',$stockTransaction['warehouse_id'])
            ->where('vendorid',$stockTransaction['vendorid']==null?0:$stockTransaction['vendorid'])
            ->where('organisation_id',$user['organisation_id'])
            ->where('fy',$stockTransaction['fy'])
            //dd($stocks);
            ->increment('quantity',$increment);
        } else {
            $modifieddatecarbon = Carbon::createfromformat('Y-m-d',$modifiedDate['dailydate']);
            $todaydatecarbon = Carbon::createfromformat('Y-m-d',$stockTransaction['transaction_date'])->addDay(2);
            DailyStock::where('dailydate','>',$todaydatecarbon->format('Y-m-d'))
            ->where('dailydate','<',$modifieddatecarbon->format('Y-m-d'))
            ->where('item_id',$stockTransaction['item_id'])
            ->where('warehouse_id',$stockTransaction['warehouse_id'])
            ->where('vendorid',$stockTransaction['vendorid']==null?0:$stockTransaction['vendorid'])
            ->where('organisation_id',$user['organisation_id'])
            ->where('fy',$stockTransaction['fy'])
            ->increment('quantity',$increment);
        }
    }
}