<?php

namespace App\Service;
use App\Models\User;
use Log;
use Auth;

class FamilyEmployeeService
{
    public function familyEmployeeCreateUpdate($request, $user){

        $parent_id = $user['id']; 
        
        if(isset($request['employees'])){

            $employee_ids = implode(",", array_merge([$parent_id], array_map(fn($emp) => $emp["employee_id"], $request["employees"])));

            // Update employee_ids in the user table
            $user['employee_ids']=$employee_ids??null;
            $user->update();

             // Update parent_id for each employee
            foreach ($request["employees"] as $employee) {
                // Log::info($employee);
                $obj=[];
                $obj['relation_id'] = $parent_id;
                $obj['food_type'] = $employee['food_type'];
                $obj['photo'] = $employee['photo'] ?? null;
                $obj['employee_ids'] = $employee_ids;
                
                $employee = User::where('id', $employee["employee_id"])->update($obj);
               
            }
        }

        if(isset($request['family_members'])){
            // Include parent ID in employee and family IDs
            $family_ids = implode(",", array_merge([$parent_id], array_map(fn($member) => $member["member_id"], $request["family_members"])));

            // Update family_ids in the user table
            $user['family_ids']=$family_ids;
            $user->update();

            // Update relationship, photo, and parent_id for each family member
            foreach ($request["family_members"] as $member) {
                User::where('id', $member["member_id"])->update([
                    'relationship' => $member["relationship"] ?? null,
                    'photo' => $member["photo"] ?? null,
                    'relation_id' => $parent_id,
                    'family_ids'=>$family_ids,
                    'food_type'=>$member['food_type']??null
                ]);
            }
        }
        
        return true;
        
    }


}