<?php

namespace App\Service;
use App\Models\InsuranceDetail;
use Log;
use Auth;

class InsuranceDetailService
{
    public function insuranceCreateUpdate($request, $user) {
        
        if (isset($request['insurance_details'])) {
            $insuranceDetails = $request['insurance_details']; // Correctly retrieve insurance details
            $obj = [];
    
            $obj['company_name'] = $insuranceDetails['insurance_company_name'] ?? null; // Check if key exists
            $obj['insurance_for'] = $insuranceDetails['insurance_for'] ?? "Life"; // Default to 'Life'
            $obj['policy_no'] = $insuranceDetails['policy_no'] ?? null;
            $obj['issue_date'] = $insuranceDetails['issue_date'] ?? null;
            $obj['expiry_date'] = $insuranceDetails['expiry_date'] ?? null;
            $obj['upload_documents'] = $insuranceDetails['upload_documents'] ?? null;
    
            $obj['user_id'] = $user['id'] ?? null; // Ensure user_id exists
    
            // Create and save the insurance details
            $insurance = InsuranceDetail::create($obj);

        }
    
        return true;
    }

}