<?php

namespace App\Service;
use App\Models\LedgerTransaction;
use App\Service\UtilityService;
use DB;
use Carbon\Carbon;
use App\Service\StaticMaster;
use Log;

class LedgerService
{
	public function createLedger($transaction, $inout,$user_id){
		// $ledger = LedgerTransaction::where('tran_type',)

		$obj['account_id']=$transaction[''];
		$obj['transaction_date']=$transaction['transaction_date'];
		$obj['transaction_id']=$transaction['id'];
		$obj['amount']=$transaction['total'];
		$obj['user_id']=$user_id;
		$obj['inout']=$inout;
		$obj['fy']=$transaction['fy'];
	}

	public function createDebitLedgerForCustomerAgainstOrderTransaction($order){
		
		$ledger['inout']=2;
		$ledger['trantype']=StaticMaster::$ORDER_TYPE;
		$ledger['amount']=$order['amount'];
		$ledger['transactionid']=$order['ordertranid'];
		$ledger['customerid']=$order['customerid'];
		$ledger['transactiondate']=$order['transactiondate'];
		$ledger['fy']=$order['fy'];
		$ledger = LedgerTransactions::create($ledger);

		//Log::info("createDebitLedgerForCustomerAgainstOrderTransaction");
		$dailyService = new DailyService;
		$dailyService->updateNextDayLedgerBalance($ledger);
	}

	public function createDebitLedgerAgainstOrder($paymentTransaction){
		$obj['inout']=2;
		
		$obj['trantype']=4;//making the payment
		
		$obj['amount']=$paymentTransaction['amount'];
		$obj['customerid']=$paymentTransaction['customerid'];
		$obj['transactiondate']=$paymentTransaction['transactiondate'];
		$obj['transactionid']=$paymentTransaction['id'];
		$obj['fy']=$paymentTransaction['fy'];
		$ledger = LedgerTransactions::create($obj);
		
		//Log::info("createDebitLedgerAgainstOrder");
		$dailyService = new DailyService;
		$dailyService->updateNextDayLedgerBalance($ledger);
		return $ledger;
	}

	public function createUpdateCustomerLedger($paymentTransaction){
		$obj['trantype']=3;//receiving the payment into a ledger
		$obj['amount']=$paymentTransaction['amount'];
		$obj['transactionid']=$paymentTransaction['id'];
		$obj['customerid']=$paymentTransaction['customerid'];
		$obj['transactiondate']=$paymentTransaction['transactiondate'];
		$obj['fy']=$paymentTransaction['fy'];
		$obj['inout']=2;
		$ledger = LedgerTransactions::create($obj);

		//Log::info("createUpdateCustomerLedger");
		$dailyService = new DailyService;
		$dailyService->updateNextDayLedgerBalance($ledger);
		return $ledger;
	}

	public function createUpdateRazorPayLedger($paymentTransaction){
		$obj['trantype']=3;//receiving the payment into a ledger
		$obj['amount']=$paymentTransaction['amount'];
		$obj['transactionid']=$paymentTransaction['id'];
		$obj['customerid']=$paymentTransaction['mode'];
		$obj['transactiondate']=$paymentTransaction['transactiondate'];
		$obj['fy']=$paymentTransaction['fy'];
		$obj['inout']=1;
		$ledger = LedgerTransactions::create($obj);

		//Log::info("createUpdateRazorPayLedger");
		$dailyService = new DailyService;
		$dailyService->updateNextDayLedgerBalance($ledger);
		return $ledger;
	}

	public function rollbackExpenseLedger($expense){
		$dailyService = new DailyService;
		$ledger = LedgerTransactions::where('othertransactionid',$expense['id'])
			->where('trantype',StaticMaster::$EXPENSE_TYPE)->first();
		if($ledger){
			$ledger['rolledback']=1;
			$ledger->update();

			//Log::info("rollbackExpenseLedger");
			$dailyService->updateNextDayLedgerBalance($ledger);
		}
	}

	public function createUpdateFromExpense($expense,$payment){
		$dailyService = new DailyService;
		$obj['inout']=2;//out payment
		$obj['trantype']=StaticMaster::$EXPENSE_TYPE;
		$obj['amount']=$expense['amountwithtax'];
		$obj['transactionid']=$payment['id'];
		$obj['othertransactionid']=$expense['id'];
		$obj['customerid']=$expense['mode'];
		$obj['transactiondate']=$expense['transactiondate'];
		$obj['fy']=$expense['fy'];
		$ledger = LedgerTransactions::create($obj);
		$maxsequence = LedgerTransactions::where('transactiondate',$expense['transactiondate'])->max('dailysequence');
		$ledger['dailysequence']=$maxsequence+1;
		$ledger->update();

		//Log::info("createUpdateFromExpense");
		$dailyService->updateNextDayLedgerBalance($ledger);
	}

	public function checkIfCustomerIsRegister($customerid){
		if($customerid==2){
			return true;
		}
		return false;
	}
	
	public function rollbackLedgerTransaction($transaction){
		
		$ledger = LedgerTransactions::where('transactionid',$transaction['id'])->where('rolledback',0)
			->where('updatestatus',0)->where('trantype',$transaction['trantype'])->first();
		if($ledger!=null){
			$ledger['rolledback']=1;
			$ledger->update();

			//Log::info("rollbackLedgerTransaction entered");
			$dailyService = new DailyService;
			$dailyService->updateNextDayLedgerBalance($ledger);
		}
		
	}
	
	public function getLatestLedger(){
		/*$ledger = LedgerTransactions::whereIn(DB::raw('(`sequence`,`customerid`)'),function($query){
				$query->from('ledger_transactions')->selectRaw('max(sequence),customerid')
					//->where('customerid',$transaction['customerid'])
					->groupby('customerid')->get();
			})->get();
		*/
		$ledger = LedgerTransactions::select('customerid','balance')->where('rolledback',0)->orderby('transactiondate','desc')->orderby('dailysequence','desc')->get();

		return $ledger;
	}
	
	public function disablepaymenttransaction($transaction){
		$ledger = LedgerTransactions::where('transactionid',$transaction['id'])
			->where('trantype',$transaction['trantype'])->where('inout',1)->first();
		$ledger['rolledback']=1;
		$ledger->update();

		//Log::info("disablepaymenttransaction");
		$dailyService = new DailyService;
		$dailyService->updateNextDayLedgerBalance($ledger);
		$ledger = LedgerTransactions::where('transactionid',$transaction['id'])
			->where('trantype',$transaction['trantype'])->where('inout',2)->first();
		$ledger['rolledback']=1;
		$ledger->update();
		$dailyService->updateNextDayLedgerBalance($ledger);
	}

	public function updateamount($ledger,$request){
		$ledger['amount']=0;
		$ledger['balance']=0;
		$ledger->update();
		$this->updateallfuturetransactions($ledger);
		$ledger['amount']=$request['amount'];
		$ledger->update();
		$ledger = $this->updatebalance($ledger);
		$this->updateallfuturetransactions($ledger);

		//Log::info("updateamount");
		$dailyService = new DailyService;
		$dailyService->updateNextDayLedgerBalance($ledger);
	}
	
	public function disableledgerfromcommission($transaction,$commissiontransaction){
		
		$ledger = LedgerTransactions::where('trantype',14)
			->where('transactionid',$commissiontransaction['id'])->first();
		$ledger['rolledback']=1;
		$ledger->update();
		//Log::info("disableledgerfromcommission entered");
		// $dailyService = new DailyService;
		// $dailyService->updateNextDayLedgerBalance($ledger);
		return $ledger;
	}

	public function createnewledger($transaction){
		$obj = $this->populateobjforpayment($transaction);
		$ledger = LedgerTransactions::create($obj);
		$factor=1;
		if($ledger['inout']==2){
			$factor=-1;
		}

		//new dailysequence
		$maxsequence = LedgerTransactions::where('transactiondate',$transaction['transactiondate'])->max('dailysequence');
		$ledger['dailysequence']=$maxsequence+1;
		
		$ledger->update();

		//Log::info("createnewledger entered 1st level");
		$dailyService = new DailyService;
		$dailyService->updateNextDayLedgerBalance($ledger);


		$obj = $this->populateobjforpayment($transaction);
		
		if($transaction['trantype']==3)//we are receiving the payment from the customer means out from customer ledger
			$obj['inout']=1;
		else if($transaction['trantype']==4)//making the payment means customer in into customer ledger
			$obj['inout']=2;
		//$obj['inout']=$transaction['inout'];
		$obj['customerid']=$transaction['mode'];
		$obj['paymenttype']=$transaction['paymenttype'];
		$ledger = LedgerTransactions::create($obj);
		$maxsequence = LedgerTransactions::where('transactiondate',$transaction['transactiondate'])->max('dailysequence');
		$ledger['dailysequence']=$maxsequence+1;
		$ledger->update();

		//Log::info("createnewledger entered 1st level");
		$dailyService = new DailyService;
		$dailyService->updateNextDayLedgerBalance($ledger);
		return $ledger;
	}
	
	public function disabletransfertransaction($transaction){
		$ledger = LedgerTransactions::where('transactionid',$transaction['id'])
			->where('customerid',$transaction['fromuserid'])->where('rolledback',0)
			->first();
		$this->rollbackledger($ledger);
		$ledger = LedgerTransactions::where('transactionid',$transaction['id'])
			->where('customerid',$transaction['touserid'])->where('rolledback',0)
			->first();
		$this->rollbackledger($ledger);
	}

	public function createupdateforcontraentry($transaction){
		$dailyService = new DailyService;
		$obj['inout']=2;//out payment
		$obj['trantype']=9;
		$obj['amount']=$transaction['amount'];
		$obj['transactionid']=$transaction['id'];
		$obj['customerid']=$transaction['fromuserid'];
		$obj['transactiondate']=$transaction['transactiondate'];
		$obj['fy']=$transaction['fy'];
		$ledger = LedgerTransactions::create($obj);
		$maxsequence = LedgerTransactions::where('transactiondate',$transaction['transactiondate'])->max('dailysequence');
		$ledger['dailysequence']=$maxsequence+1;
		$ledger->update();

		//Log::info("createupdateforcontraentry 1st level");
		$dailyService->updateNextDayLedgerBalance($ledger);

		$obj['inout']=1;
		$obj['customerid']=$transaction['touserid'];
		$ledger = LedgerTransactions::create($obj);

		$maxsequence = LedgerTransactions::where('transactiondate',$transaction['transactiondate'])->max('dailysequence');
		$ledger['dailysequence']=$maxsequence+1;
		$ledger->update();

		//Log::info("createupdateforcontraentry 2st level");
		$dailyService->updateNextDayLedgerBalance($ledger);
		
		
	}

	public function populateobjforpayment($transaction){
		if($transaction['trantype']==1)
			$obj['inout']=2;
		else if($transaction['trantype']==1)
			$obj['inout']=1;
		else if($transaction['trantype']==3)//we are receiving the payment from the customer means out from customer ledger
			$obj['inout']=2;
		else if($transaction['trantype']==4)//making the payment means customer in into customer ledger
			$obj['inout']=1;
		$obj['inout']=$transaction['inout']==1?2:1;//==1?2:1;//if receiving the payment then payment is out from the ledger
		$obj['trantype']=$transaction['inout']==1?3:4;
		$obj['paymenttype']=$transaction['paymenttype']??0;
		$obj['amount']=$transaction['amount'];
		$obj['customerid']=$transaction['customerid'];
		$obj['transactiondate']=$transaction['transactiondate'];
		$obj['transactionid']=$transaction['id'];
		$obj['fy']=$transaction['fy'];
		return $obj;
	}
	
	public function createupdate($transaction,$type){
		$ledger = LedgerTransactions::where('transactionid',$transaction['id'])->where('trantype',$transaction['inout'])
			->where('rolledback',0)->where('customerid',$transaction['customerid'])->first();
		//if amount is changed
		//if transaction date is changed
		if($ledger!=null){
			if($ledger['amount']!=$transaction['amountwithtax'] || $ledger['transactiondate']!=$transaction['transactiondate']){
			//rollback the ledger
				$ledger['rolledback']=1;
				$ledger->update();

				//Log::info("createupdate 1st level");
				$dailyService = new DailyService;
				$dailyService->updateNextDayLedgerBalance($ledger);
				//$this->rollbackallfuturetransactions($ledger);
				$obj = array();
				$ledger = $this->populateobj($obj,$transaction,$type);
				$ledger = LedgerTransactions::create($ledger);
				
				$ledger = $this->updatesequence($ledger);
				$this->updatebalance1($ledger);
				$factor = 1;
				if($ledger['inout']==1){
					$factor = -1;
				}
				$maxsequence = LedgerTransactions::where('transactiondate',$transaction['transactiondate'])->max('dailysequence');
				$ledger['dailysequence']=$maxsequence+1;
				$ledger->update();

				//Log::info("createupdate 2nd ");
				$dailyService = new DailyService;
				$dailyService->updateNextDayLedgerBalance($ledger);
			} else {
			//dont do anything
			}
		} else {
			$ledger = $this->populateobj($ledger,$transaction,$type);
			$ledger = LedgerTransactions::create($ledger);
			$ledger = $this->updatesequence($ledger);
			$this->updatebalance1($ledger);
			$factor = -1;
			if($ledger['inout']==1){
				$factor = 1;
			}
			$maxsequence = LedgerTransactions::where('transactiondate',$transaction['transactiondate'])->max('dailysequence');
			$ledger['dailysequence']=$maxsequence+1;
			$ledger->update();

			$ledger->update();

			//Log::info("createupdate else condition");
			$dailyService = new DailyService;
			$dailyService->updateNextDayLedgerBalance($ledger);
			$ledger->update();
		}

		
		return $ledger;
	}
	
	public function updatesequence($ledger){
		
		/*$previous = LedgerTransactions::whereRaw('date(transactiondate)<=date("'.$ledger['transactiondate'].'")')
			->where('customerid',$ledger['customerid'])
			->where('rolledback',0)->where('updatestatus',0)->orderby('sequence','desc')->first();
		$next = LedgerTransactions::whereRaw('date(transactiondate)>date("'.$ledger['transactiondate'].'")')
			->where('customerid',$ledger['customerid'])
			->where('rolledback',0)->where('updatestatus',0)->orderby('sequence','asc')->first();
		$utilityService = new UtilityService;
		$ledger = $utilityService->updatesequence($previous,$next,$ledger);
		*/

		$previous = LedgerTransactions::
			whereRaw('date(transactiondate)<=date("'.$ledger['transactiondate'].'")')
			->where('customerid',$ledger['customerid'])->where('rolledback',0)->where('updatestatus',0)
			->where('id','<>',$ledger['id'])
			->orderbyRaw('date(transactiondate) desc')->orderby('id','desc')->first();
		$next = null;
		if($previous!=null){
			$previousnext = $previous;
			while($previousnext!=null){
				$ledgerdate = Carbon::createFromFormat('Y-m-d',$previous['transactiondate']);
				$previousnext = LedgerTransactions::where('id',$previousnext['nextid'])->where('customerid',$ledger['customerid'])->where('id','<>',$ledger['id'])->first();
				if($previousnext!=null){
					if($previousnext['rolledback']==0){
						//if the date is less or same as ledger date then go for the next id
						$rowdate = Carbon::createFromFormat('Y-m-d',$previousnext['transactiondate']);
						if($rowdate->greaterThan($ledgerdate)){
							$previousnext=null;
						} else {
							$previous = $previousnext;
						}
					}
				}
			}
			$next = LedgerTransactions::where('id',$previous['nextid'])->where('customerid',$ledger['customerid'])->first();
			while($next!=null && $next['rolledback']==1){
				$next = LedgerTransactions::where('id',$next['nextid'])->where('customerid',$ledger['customerid'])->first();
			}
			if($next!=null && $next['rolledback']==1){
				$next=null;
			}
		} else {
			$next = LedgerTransactions::
				whereRaw('date(transactiondate)>date("'.$ledger['transactiondate'].'")')
				->where('customerid',$ledger['customerid'])->where('rolledback',0)->where('updatestatus',0)
				->where('id','<>',$ledger['id'])
				->orderbyRaw('date(transactiondate) asc')->orderby('id','asc')->first();
			$nextprev = $next;
			while($nextprev!=null){
				$nextdate = Carbon::createFromFormat('Y-m-d',$next['transactiondate']);
				$nextprev = LedgerTransactions::where('id',$nextprev['previd'])->where('customerid',$ledger['customerid'])->where('id','<>',$ledger['id'])->first();
				if($nextprev!=null){
					if($nextprev['rolledback']==0){
						//if the date is less or same as ledger date then go for the next id
						$rowdate = Carbon::createFromFormat('Y-m-d',$nextprev['transactiondate']);
						if($rowdate->greaterThan($nextdate)){
							$nextprev=null;
						} else {
							$next = $nextprev;
						}
					}
				}
			}
		}

		if($previous!=null && $next!=null){
			$ledger['previd']=$previous['id'];
			$ledger['nextid']=$previous['nextid'];
			$previous['nextid']=$ledger['id'];
			$next['previd']=$ledger['id'];
			$next->update();
			$ledger->update();
			$previous->update();
		} else if($previous!=null && $next==null){
			$ledger['previd']=$previous['id'];
			$ledger['nextid']=$previous['nextid'];
			$previous['nextid']=$ledger['id'];
			$ledger->update();
			$previous->update();
		} else if($previous==null && $next!=null){
			$ledger['previd']=$next['previd'];
			$ledger['nextid']=$next['id'];
			$next['previd']=$ledger['id'];
			$ledger->update();
			$next->update();
		} else {

		}

		return $ledger;
	}
	
	public function rollbackledger($ledger){
		$previous = LedgerTransactions::where('sequence','<',$ledger['sequence'])->where('customerid',$ledger['customerid'])
			->where('updatestatus',0)->where('rolledback',0)->orderby('sequence','desc')->first();
		if($previous==null){
			$ledger['balance']=0;
			$ledger->update();
		} else {
			$ledger['balance']=$previous['balance'];
			$ledger->update();
		}
		$this->rollbackallfuturetransactions($ledger);
		$ledger['sequence']=0;
		$ledger['rolledback']=1;
		$ledger->update();

		//Log::info("Rollbackledger entered");
		$dailyService = new DailyService;
		$dailyService->updateNextDayLedgerBalance($ledger);
		return $previous;
	}

	public function rollbackledger1($ledger){
		$previous = LedgerTransactions::where('id',$ledger['previd'])->first();
		while($previous!=null && $previous['rolledback']==1){
			$previous = LedgerTransactions::where('id',$previous['previd'])->first();
		}
		if($previous==null){
			$ledger['balance']=0;
			$ledger->update();
		} else {
			$ledger['balance']=$previous['balance'];
			$ledger->update();
		}
		$factor=1;
		if($ledger['inout']==1){
			$factor=-1;
		}
		$ledger['rolledback']=1;
		$ledger->update();
		
		// //Log::info("rollbackledger1 call");
		$dailyService = new DailyService;
		$dailyService->updateNextDayLedgerBalance($ledger);
		return $previous;
	}
	
	public function rollbackallfuturetransactions($ledger){
		
		if($ledger['inout']==1){
			DB::statement("update ledger_transactions set balance = balance + ".$ledger['amount']." where transactiondate>'".$ledger['transactiondate']."' and id!=".$ledger['id']." and rolledback=0");

			//need to work for the same date transactions
		} else {
			DB::statement("update ledger_transactions set balance = balance - ".$ledger['amount']." where transactiondate>'".$ledger['	transactiondate']."' and id!=".$ledger['id']." and rolledback=0");
		}
		
	}

	public function updateallfuturetransactions($base){
		if($base!=null){
			$futures = LedgerTransactions::where('sequence','>',$base['sequence'])->where('customerid',$base['customerid'])->where('id','<>',$base['id'])->where('rolledback',0)->orderby('sequence','asc')->get();
			dd($futures);
			$previous = $base;
			foreach($futures as $row){
				if($row['inout']==1)
					$row['balance']=$previous['balance']+$row['amount'];
				else
					$row['balance']=$previous['balance']-$row['amount'];
				$row->update();
				$previous = $row;
			}
		}
	}
	
	public function populateobj($obj,$trn,$type){
		if($trn['trantype']==1)
			$obj['inout']=2;
		else if($trn['trantype']==2)
			$obj['inout']=1;
		else
			$obj['inout']=$trn['inout'];
		$obj['trantype']=$trn['trantype'];
		$obj['amount']=$trn['amountwithtax'];
		$obj['transactionid']=$trn['id'];
		$obj['customerid']=$trn['customerid'];
		$obj['transactiondate']=$trn['transactiondate'];
		$obj['fy']=$trn['fy'];
		return $obj;
	}
	
	public function updatebalance($ledger){
		//get the previous balance
		$previous = LedgerTransactions::where('id',$ledger['previd'])->where('customerid',$ledger['customerid'])
		->first();
		if($previous !=null){
			if($ledger['inout']==1){
				$ledger['balance']=$previous['balance']+$ledger['amount'];
			} else {
				$ledger['balance']=$previous['balance']-$ledger['amount'];
			}
			$ledger->update();
		} else {
			if($ledger['inout']==1){
				$ledger['balance']=$ledger['amount'];
			} else {
				$ledger['balance']=-$ledger['amount'];
			}
			$ledger->update();
		}
		return $ledger;
	}

	public function updatebalance1($ledger){
		$previous = LedgerTransactions::where('id',$ledger['previd'])->first();
		if($previous!=null){
			while($previous!=null && $previous['rolledback']!=0){
				$previous = LedgerTransactions::where('id',$previous['previd'])->first();
			}
			
		}
		if($previous!=null){
			//get the balance quantity and then update the current transaction and call the function
			if($ledger['inout']==1)
				$ledger['balance']=$previous['balance']+$ledger['amount'];
			else
				$ledger['balance']=$previous['balance']-$ledger['amount'];
			$ledger['updatestatus']=0;
			$ledger->update();
		} else {
			if($ledger['inout']==1)
				$ledger['balance']=$ledger['amount'];
			else
				$ledger['balance']=-$ledger['amount'];
			$ledger['updatestatus']=0;
			$ledger->update();
		}
	}

	public function processfuturebalance($ledger,$factor){
		$modifiedtransaction = LedgerTransactions::where('customerid',$ledger['customerid'])->where('trantype',11)->whereRaw("transactiondate>'".$ledger['transactiondate']."'")->where('rolledback',0)->where('id','<>',$ledger['id'])->first();
		if($modifiedtransaction!=null){
			DB::statement("update ledger_transactions set balance = balance + ".($ledger['amount']*$factor)." where customerid=".$ledger['customerid']." and transactiondate>'".$ledger['transactiondate']."' and transactiondate<'". $modifiedtransaction['transactiondate'] ."' and id!=".$ledger['id']." and rolledback=0");
			$nextstock = LedgerTransactions::where('customerid',$ledger['customerid'])->where('id',$ledger['nextid'])->whereRaw("transactiondate='".$ledger['transactiondate']."'")->first();
			while($nextstock!=null){
				$nextstock['balance']=$nextstock['balance'] + ($ledger['amount']*$factor);
				$nextstock->update();
				$nextstock = LedgerTransactions::where('customerid',$ledger['customerid'])->where('id',$nextstock['nextid'])->whereRaw("transactiondate='".$ledger['transactiondate']."'")->first();
			}

			//go to the previous 
			$prevstock = LedgerTransactions::where('customerid',$ledger['customerid'])->where('id',$modifiedtransaction['previd'])->whereRaw("transactiondate='".$modifiedtransaction['transactiondate']."'")->first();
			while($prevstock!=null){
				$prevstock['balance']=$prevstock['balance'] + ($ledger['amount']*$factor);
				$prevstock->update();
				$prevstock = LedgerTransactions::where('customerid',$ledger['customerid'])->where('id',$prevstock['previd'])->whereRaw("transactiondate='".$modifiedtransaction['transactiondate']."'")->first();
			}

		} else {
			DB::statement("update ledger_transactions set balance = balance + ".($ledger['amount']*$factor)." where customerid=".$ledger['customerid']." and transactiondate>'".$ledger['transactiondate']."' and id!=".$ledger['id']." and rolledback=0");
			
			$nextstock = LedgerTransactions::where('customerid',$ledger['customerid'])->where('id',$ledger['nextid'])->whereRaw("transactiondate='".$ledger['transactiondate']."'")->first();
			while($nextstock!=null){
				$nextstock['balance']=$nextstock['balance'] + ($ledger['amount']*$factor);
				$nextstock->update();
				$nextstock = LedgerTransactions::where('customerid',$ledger['customerid'])->where('id',$nextstock['nextid'])->whereRaw("transactiondate='".$ledger['transactiondate']."'")->first();
			}

		}
	}
	public function createCreditAndDebitLedger($creditnote,$user){
		if($creditnote['trantype']==StaticMaster::$CREDIT_NOTE){
			$obj['inout']=1;
			$obj['creditnoteid']=$creditnote['id'];
		} //credit
			
		else if($creditnote['trantype']==StaticMaster::$DEBIT_NOTE){
			$obj['inout']=2;
			$obj['debitnoteid']=$creditnote['id'];
		} //debit
			
		$obj['trantype']=$creditnote['trantype'];
		$obj['amount']=$creditnote['amountwithtax'];
		$obj['customerid']=$creditnote['customerid'];
		$obj['transactiondate']=$creditnote['transactiondate'];
		$obj['fy']=$creditnote['fy'];
		$ledger=LedgerTransactions::create($obj);
		return $ledger;
	}
	public function rollbackCreditAndDebitLedger($transaction,$user){
		$transactioncolumn='';
		if($transaction['trantype']==StaticMaster::$CREDIT_NOTE){
			$transactioncolumn='creditnoteid';
		}else{
			$transactioncolumn='debitnoteid';
		}
		$ledger = LedgerTransactions::where('companyid',$user['companyid'])
			->where($transactioncolumn,$transaction['id'])->where('rolledback',0)
			->where('updatestatus',0)->where('trantype',$transaction['trantype'])->first();
		if($ledger!=null){
			$ledger['rolledback']=1;
			$ledger->update();

			//Log::info("rollbackLedgerTransaction entered");
			$dailyService = new DailyService;
			$dailyService->updateNextDayLedgerBalance($ledger);
		}
		
	}
	
	
}
